/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateGeometrySetRequest;
import com.vertexvis.model.GeometrySet;
import com.vertexvis.model.GeometrySetList;
import com.vertexvis.model.QueuedJob;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class GeometrySetsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public GeometrySetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GeometrySetsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createGeometrySetCall(@Nonnull CreateGeometrySetRequest createGeometrySetRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateGeometrySetRequest localVarPostBody = createGeometrySetRequest;
        String localVarPath = "/geometry-sets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createGeometrySetValidateBeforeCall(@Nonnull CreateGeometrySetRequest createGeometrySetRequest, ApiCallback _callback) throws ApiException {
        if (createGeometrySetRequest == null) {
            throw new ApiException("Missing the required parameter 'createGeometrySetRequest' when calling createGeometrySet(Async)");
        }
        return this.createGeometrySetCall(createGeometrySetRequest, _callback);
    }

    public QueuedJob createGeometrySet(@Nonnull CreateGeometrySetRequest createGeometrySetRequest) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.createGeometrySetWithHttpInfo(createGeometrySetRequest);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> createGeometrySetWithHttpInfo(@Nonnull CreateGeometrySetRequest createGeometrySetRequest) throws ApiException {
        Call localVarCall = this.createGeometrySetValidateBeforeCall(createGeometrySetRequest, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createGeometrySetAsync(@Nonnull CreateGeometrySetRequest createGeometrySetRequest, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.createGeometrySetValidateBeforeCall(createGeometrySetRequest, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGeometrySetCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/geometry-sets/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGeometrySetValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getGeometrySet(Async)");
        }
        return this.getGeometrySetCall(id, _callback);
    }

    public GeometrySet getGeometrySet(@Nonnull UUID id) throws ApiException {
        ApiResponse<GeometrySet> localVarResp = this.getGeometrySetWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<GeometrySet> getGeometrySetWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getGeometrySetValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<GeometrySet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGeometrySetAsync(@Nonnull UUID id, ApiCallback<GeometrySet> _callback) throws ApiException {
        Call localVarCall = this.getGeometrySetValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<GeometrySet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGeometrySetsCall(@Nullable String pageCursor, @Nullable Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/geometry-sets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGeometrySetsValidateBeforeCall(@Nullable String pageCursor, @Nullable Integer pageSize, ApiCallback _callback) throws ApiException {
        return this.getGeometrySetsCall(pageCursor, pageSize, _callback);
    }

    public GeometrySetList getGeometrySets(@Nullable String pageCursor, @Nullable Integer pageSize) throws ApiException {
        ApiResponse<GeometrySetList> localVarResp = this.getGeometrySetsWithHttpInfo(pageCursor, pageSize);
        return localVarResp.getData();
    }

    public ApiResponse<GeometrySetList> getGeometrySetsWithHttpInfo(@Nullable String pageCursor, @Nullable Integer pageSize) throws ApiException {
        Call localVarCall = this.getGeometrySetsValidateBeforeCall(pageCursor, pageSize, null);
        Type localVarReturnType = new TypeToken<GeometrySetList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGeometrySetsAsync(@Nullable String pageCursor, @Nullable Integer pageSize, ApiCallback<GeometrySetList> _callback) throws ApiException {
        Call localVarCall = this.getGeometrySetsValidateBeforeCall(pageCursor, pageSize, _callback);
        Type localVarReturnType = new TypeToken<GeometrySetList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

