/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateSceneItemRequest;
import com.vertexvis.model.QueuedJob;
import com.vertexvis.model.SceneItem;
import com.vertexvis.model.SceneItemList;
import com.vertexvis.model.UpdateSceneItemRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class SceneItemsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SceneItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SceneItemsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSceneItemCall(@Nonnull UUID id, @Nonnull CreateSceneItemRequest createSceneItemRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateSceneItemRequest localVarPostBody = createSceneItemRequest;
        String localVarPath = "/scenes/{id}/scene-items".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSceneItemValidateBeforeCall(@Nonnull UUID id, @Nonnull CreateSceneItemRequest createSceneItemRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createSceneItem(Async)");
        }
        if (createSceneItemRequest == null) {
            throw new ApiException("Missing the required parameter 'createSceneItemRequest' when calling createSceneItem(Async)");
        }
        return this.createSceneItemCall(id, createSceneItemRequest, _callback);
    }

    public QueuedJob createSceneItem(@Nonnull UUID id, @Nonnull CreateSceneItemRequest createSceneItemRequest) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.createSceneItemWithHttpInfo(id, createSceneItemRequest);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> createSceneItemWithHttpInfo(@Nonnull UUID id, @Nonnull CreateSceneItemRequest createSceneItemRequest) throws ApiException {
        Call localVarCall = this.createSceneItemValidateBeforeCall(id, createSceneItemRequest, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSceneItemAsync(@Nonnull UUID id, @Nonnull CreateSceneItemRequest createSceneItemRequest, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.createSceneItemValidateBeforeCall(id, createSceneItemRequest, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSceneItemCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scene-items/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSceneItemValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteSceneItem(Async)");
        }
        return this.deleteSceneItemCall(id, _callback);
    }

    public void deleteSceneItem(@Nonnull UUID id) throws ApiException {
        this.deleteSceneItemWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteSceneItemWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.deleteSceneItemValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSceneItemAsync(@Nonnull UUID id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSceneItemValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getQueuedSceneItemCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/queued-scene-items/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedSceneItemValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedSceneItem(Async)");
        }
        return this.getQueuedSceneItemCall(id, _callback);
    }

    public QueuedJob getQueuedSceneItem(@Nonnull UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedSceneItemWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedSceneItemWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getQueuedSceneItemValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedSceneItemAsync(@Nonnull UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedSceneItemValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getQueuedSceneItemDeletionCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/queued-scene-item-deletions/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedSceneItemDeletionValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedSceneItemDeletion(Async)");
        }
        return this.getQueuedSceneItemDeletionCall(id, _callback);
    }

    public QueuedJob getQueuedSceneItemDeletion(@Nonnull UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedSceneItemDeletionWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedSceneItemDeletionWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getQueuedSceneItemDeletionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedSceneItemDeletionAsync(@Nonnull UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedSceneItemDeletionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSceneItemCall(@Nonnull UUID id, @Nullable String fieldsSceneItem, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scene-items/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fieldsSceneItem != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields[scene-item]", fieldsSceneItem));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSceneItemValidateBeforeCall(@Nonnull UUID id, @Nullable String fieldsSceneItem, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSceneItem(Async)");
        }
        return this.getSceneItemCall(id, fieldsSceneItem, _callback);
    }

    public SceneItem getSceneItem(@Nonnull UUID id, @Nullable String fieldsSceneItem) throws ApiException {
        ApiResponse<SceneItem> localVarResp = this.getSceneItemWithHttpInfo(id, fieldsSceneItem);
        return localVarResp.getData();
    }

    public ApiResponse<SceneItem> getSceneItemWithHttpInfo(@Nonnull UUID id, @Nullable String fieldsSceneItem) throws ApiException {
        Call localVarCall = this.getSceneItemValidateBeforeCall(id, fieldsSceneItem, null);
        Type localVarReturnType = new TypeToken<SceneItem>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSceneItemAsync(@Nonnull UUID id, @Nullable String fieldsSceneItem, ApiCallback<SceneItem> _callback) throws ApiException {
        Call localVarCall = this.getSceneItemValidateBeforeCall(id, fieldsSceneItem, _callback);
        Type localVarReturnType = new TypeToken<SceneItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSceneItemsCall(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSource, @Nullable String filterSuppliedId, @Nullable UUID filterParent, @Nullable Boolean filterHasChildren, @Nullable Boolean filterHasGeometrySet, @Nullable String sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scenes/{id}/scene-items".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if (filterSource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[source]", filterSource));
        }
        if (filterSuppliedId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[suppliedId]", filterSuppliedId));
        }
        if (filterParent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[parent]", filterParent));
        }
        if (filterHasChildren != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[hasChildren]", filterHasChildren));
        }
        if (filterHasGeometrySet != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[hasGeometrySet]", filterHasGeometrySet));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSceneItemsValidateBeforeCall(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSource, @Nullable String filterSuppliedId, @Nullable UUID filterParent, @Nullable Boolean filterHasChildren, @Nullable Boolean filterHasGeometrySet, @Nullable String sort, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSceneItems(Async)");
        }
        return this.getSceneItemsCall(id, pageCursor, pageSize, filterSource, filterSuppliedId, filterParent, filterHasChildren, filterHasGeometrySet, sort, _callback);
    }

    public SceneItemList getSceneItems(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSource, @Nullable String filterSuppliedId, @Nullable UUID filterParent, @Nullable Boolean filterHasChildren, @Nullable Boolean filterHasGeometrySet, @Nullable String sort) throws ApiException {
        ApiResponse<SceneItemList> localVarResp = this.getSceneItemsWithHttpInfo(id, pageCursor, pageSize, filterSource, filterSuppliedId, filterParent, filterHasChildren, filterHasGeometrySet, sort);
        return localVarResp.getData();
    }

    public ApiResponse<SceneItemList> getSceneItemsWithHttpInfo(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSource, @Nullable String filterSuppliedId, @Nullable UUID filterParent, @Nullable Boolean filterHasChildren, @Nullable Boolean filterHasGeometrySet, @Nullable String sort) throws ApiException {
        Call localVarCall = this.getSceneItemsValidateBeforeCall(id, pageCursor, pageSize, filterSource, filterSuppliedId, filterParent, filterHasChildren, filterHasGeometrySet, sort, null);
        Type localVarReturnType = new TypeToken<SceneItemList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSceneItemsAsync(@Nonnull UUID id, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterSource, @Nullable String filterSuppliedId, @Nullable UUID filterParent, @Nullable Boolean filterHasChildren, @Nullable Boolean filterHasGeometrySet, @Nullable String sort, ApiCallback<SceneItemList> _callback) throws ApiException {
        Call localVarCall = this.getSceneItemsValidateBeforeCall(id, pageCursor, pageSize, filterSource, filterSuppliedId, filterParent, filterHasChildren, filterHasGeometrySet, sort, _callback);
        Type localVarReturnType = new TypeToken<SceneItemList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSceneItemCall(@Nonnull UUID id, @Nonnull UpdateSceneItemRequest updateSceneItemRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateSceneItemRequest localVarPostBody = updateSceneItemRequest;
        String localVarPath = "/scene-items/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSceneItemValidateBeforeCall(@Nonnull UUID id, @Nonnull UpdateSceneItemRequest updateSceneItemRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSceneItem(Async)");
        }
        if (updateSceneItemRequest == null) {
            throw new ApiException("Missing the required parameter 'updateSceneItemRequest' when calling updateSceneItem(Async)");
        }
        return this.updateSceneItemCall(id, updateSceneItemRequest, _callback);
    }

    public QueuedJob updateSceneItem(@Nonnull UUID id, @Nonnull UpdateSceneItemRequest updateSceneItemRequest) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.updateSceneItemWithHttpInfo(id, updateSceneItemRequest);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> updateSceneItemWithHttpInfo(@Nonnull UUID id, @Nonnull UpdateSceneItemRequest updateSceneItemRequest) throws ApiException {
        Call localVarCall = this.updateSceneItemValidateBeforeCall(id, updateSceneItemRequest, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSceneItemAsync(@Nonnull UUID id, @Nonnull UpdateSceneItemRequest updateSceneItemRequest, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.updateSceneItemValidateBeforeCall(id, updateSceneItemRequest, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

