/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateSceneRequest;
import com.vertexvis.model.QueuedJob;
import com.vertexvis.model.Scene;
import com.vertexvis.model.SceneList;
import com.vertexvis.model.UpdateSceneRequest;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ScenesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ScenesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScenesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSceneCall(@Nonnull CreateSceneRequest createSceneRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateSceneRequest localVarPostBody = createSceneRequest;
        String localVarPath = "/scenes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSceneValidateBeforeCall(@Nonnull CreateSceneRequest createSceneRequest, ApiCallback _callback) throws ApiException {
        if (createSceneRequest == null) {
            throw new ApiException("Missing the required parameter 'createSceneRequest' when calling createScene(Async)");
        }
        return this.createSceneCall(createSceneRequest, _callback);
    }

    public Scene createScene(@Nonnull CreateSceneRequest createSceneRequest) throws ApiException {
        ApiResponse<Scene> localVarResp = this.createSceneWithHttpInfo(createSceneRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Scene> createSceneWithHttpInfo(@Nonnull CreateSceneRequest createSceneRequest) throws ApiException {
        Call localVarCall = this.createSceneValidateBeforeCall(createSceneRequest, null);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSceneAsync(@Nonnull CreateSceneRequest createSceneRequest, ApiCallback<Scene> _callback) throws ApiException {
        Call localVarCall = this.createSceneValidateBeforeCall(createSceneRequest, _callback);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSceneCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scenes/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSceneValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteScene(Async)");
        }
        return this.deleteSceneCall(id, _callback);
    }

    public void deleteScene(@Nonnull UUID id) throws ApiException {
        this.deleteSceneWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteSceneWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.deleteSceneValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSceneAsync(@Nonnull UUID id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSceneValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getQueuedSceneCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/queued-scenes/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedSceneValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedScene(Async)");
        }
        return this.getQueuedSceneCall(id, _callback);
    }

    public QueuedJob getQueuedScene(@Nonnull UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedSceneWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedSceneWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getQueuedSceneValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedSceneAsync(@Nonnull UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedSceneValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSceneCall(@Nonnull UUID id, @Nullable String fieldsScene, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scenes/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fieldsScene != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields[scene]", fieldsScene));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSceneValidateBeforeCall(@Nonnull UUID id, @Nullable String fieldsScene, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getScene(Async)");
        }
        return this.getSceneCall(id, fieldsScene, _callback);
    }

    public Scene getScene(@Nonnull UUID id, @Nullable String fieldsScene) throws ApiException {
        ApiResponse<Scene> localVarResp = this.getSceneWithHttpInfo(id, fieldsScene);
        return localVarResp.getData();
    }

    public ApiResponse<Scene> getSceneWithHttpInfo(@Nonnull UUID id, @Nullable String fieldsScene) throws ApiException {
        Call localVarCall = this.getSceneValidateBeforeCall(id, fieldsScene, null);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSceneAsync(@Nonnull UUID id, @Nullable String fieldsScene, ApiCallback<Scene> _callback) throws ApiException {
        Call localVarCall = this.getSceneValidateBeforeCall(id, fieldsScene, _callback);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getScenesCall(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterName, @Nullable String filterSuppliedId, @Nullable String fieldsScene, @Nullable Map<String, String> filterMetadata, @Nullable String filterSceneItemsSourcePartRevision, @Nullable String filterSceneItemsSourceGeometrySet, @Nullable String filterSceneItemsSourceScene, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scenes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if (filterName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[name]", filterName));
        }
        if (filterSuppliedId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[suppliedId]", filterSuppliedId));
        }
        if (fieldsScene != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields[scene]", fieldsScene));
        }
        if (filterMetadata != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[metadata]", filterMetadata));
        }
        if (filterSceneItemsSourcePartRevision != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[sceneItems.source.partRevision]", filterSceneItemsSourcePartRevision));
        }
        if (filterSceneItemsSourceGeometrySet != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[sceneItems.source.geometrySet]", filterSceneItemsSourceGeometrySet));
        }
        if (filterSceneItemsSourceScene != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[sceneItems.source.scene]", filterSceneItemsSourceScene));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getScenesValidateBeforeCall(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterName, @Nullable String filterSuppliedId, @Nullable String fieldsScene, @Nullable Map<String, String> filterMetadata, @Nullable String filterSceneItemsSourcePartRevision, @Nullable String filterSceneItemsSourceGeometrySet, @Nullable String filterSceneItemsSourceScene, ApiCallback _callback) throws ApiException {
        return this.getScenesCall(pageCursor, pageSize, filterName, filterSuppliedId, fieldsScene, filterMetadata, filterSceneItemsSourcePartRevision, filterSceneItemsSourceGeometrySet, filterSceneItemsSourceScene, _callback);
    }

    public SceneList getScenes(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterName, @Nullable String filterSuppliedId, @Nullable String fieldsScene, @Nullable Map<String, String> filterMetadata, @Nullable String filterSceneItemsSourcePartRevision, @Nullable String filterSceneItemsSourceGeometrySet, @Nullable String filterSceneItemsSourceScene) throws ApiException {
        ApiResponse<SceneList> localVarResp = this.getScenesWithHttpInfo(pageCursor, pageSize, filterName, filterSuppliedId, fieldsScene, filterMetadata, filterSceneItemsSourcePartRevision, filterSceneItemsSourceGeometrySet, filterSceneItemsSourceScene);
        return localVarResp.getData();
    }

    public ApiResponse<SceneList> getScenesWithHttpInfo(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterName, @Nullable String filterSuppliedId, @Nullable String fieldsScene, @Nullable Map<String, String> filterMetadata, @Nullable String filterSceneItemsSourcePartRevision, @Nullable String filterSceneItemsSourceGeometrySet, @Nullable String filterSceneItemsSourceScene) throws ApiException {
        Call localVarCall = this.getScenesValidateBeforeCall(pageCursor, pageSize, filterName, filterSuppliedId, fieldsScene, filterMetadata, filterSceneItemsSourcePartRevision, filterSceneItemsSourceGeometrySet, filterSceneItemsSourceScene, null);
        Type localVarReturnType = new TypeToken<SceneList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getScenesAsync(@Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String filterName, @Nullable String filterSuppliedId, @Nullable String fieldsScene, @Nullable Map<String, String> filterMetadata, @Nullable String filterSceneItemsSourcePartRevision, @Nullable String filterSceneItemsSourceGeometrySet, @Nullable String filterSceneItemsSourceScene, ApiCallback<SceneList> _callback) throws ApiException {
        Call localVarCall = this.getScenesValidateBeforeCall(pageCursor, pageSize, filterName, filterSuppliedId, fieldsScene, filterMetadata, filterSceneItemsSourcePartRevision, filterSceneItemsSourceGeometrySet, filterSceneItemsSourceScene, _callback);
        Type localVarReturnType = new TypeToken<SceneList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call renderSceneCall(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/scenes/{id}/image".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (height != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("height", height));
        }
        if (width != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("width", width));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"image/jpeg", "image/png", "application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call renderSceneValidateBeforeCall(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling renderScene(Async)");
        }
        return this.renderSceneCall(id, height, width, _callback);
    }

    public File renderScene(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width) throws ApiException {
        ApiResponse<File> localVarResp = this.renderSceneWithHttpInfo(id, height, width);
        return localVarResp.getData();
    }

    public ApiResponse<File> renderSceneWithHttpInfo(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width) throws ApiException {
        Call localVarCall = this.renderSceneValidateBeforeCall(id, height, width, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call renderSceneAsync(@Nonnull UUID id, @Nullable Integer height, @Nullable Integer width, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.renderSceneValidateBeforeCall(id, height, width, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSceneCall(@Nonnull UUID id, @Nonnull UpdateSceneRequest updateSceneRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateSceneRequest localVarPostBody = updateSceneRequest;
        String localVarPath = "/scenes/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSceneValidateBeforeCall(@Nonnull UUID id, @Nonnull UpdateSceneRequest updateSceneRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateScene(Async)");
        }
        if (updateSceneRequest == null) {
            throw new ApiException("Missing the required parameter 'updateSceneRequest' when calling updateScene(Async)");
        }
        return this.updateSceneCall(id, updateSceneRequest, _callback);
    }

    public Scene updateScene(@Nonnull UUID id, @Nonnull UpdateSceneRequest updateSceneRequest) throws ApiException {
        ApiResponse<Scene> localVarResp = this.updateSceneWithHttpInfo(id, updateSceneRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Scene> updateSceneWithHttpInfo(@Nonnull UUID id, @Nonnull UpdateSceneRequest updateSceneRequest) throws ApiException {
        Call localVarCall = this.updateSceneValidateBeforeCall(id, updateSceneRequest, null);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSceneAsync(@Nonnull UUID id, @Nonnull UpdateSceneRequest updateSceneRequest, ApiCallback<Scene> _callback) throws ApiException {
        Call localVarCall = this.updateSceneValidateBeforeCall(id, updateSceneRequest, _callback);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

