/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateThreadRequest;
import com.vertexvis.model.Thread;
import com.vertexvis.model.ThreadList;
import com.vertexvis.model.UpdateThreadRequest;
import com.vertexvis.model.UserList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ThreadsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ThreadsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ThreadsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createThreadCall(@Nonnull UUID id, @Nonnull CreateThreadRequest createThreadRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateThreadRequest localVarPostBody = createThreadRequest;
        String localVarPath = "/collaboration-contexts/{id}/threads".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createThreadValidateBeforeCall(@Nonnull UUID id, @Nonnull CreateThreadRequest createThreadRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createThread(Async)");
        }
        if (createThreadRequest == null) {
            throw new ApiException("Missing the required parameter 'createThreadRequest' when calling createThread(Async)");
        }
        return this.createThreadCall(id, createThreadRequest, _callback);
    }

    public Thread createThread(@Nonnull UUID id, @Nonnull CreateThreadRequest createThreadRequest) throws ApiException {
        ApiResponse<Thread> localVarResp = this.createThreadWithHttpInfo(id, createThreadRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Thread> createThreadWithHttpInfo(@Nonnull UUID id, @Nonnull CreateThreadRequest createThreadRequest) throws ApiException {
        Call localVarCall = this.createThreadValidateBeforeCall(id, createThreadRequest, null);
        Type localVarReturnType = new TypeToken<Thread>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createThreadAsync(@Nonnull UUID id, @Nonnull CreateThreadRequest createThreadRequest, ApiCallback<Thread> _callback) throws ApiException {
        Call localVarCall = this.createThreadValidateBeforeCall(id, createThreadRequest, _callback);
        Type localVarReturnType = new TypeToken<Thread>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteThreadCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/threads/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteThreadValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteThread(Async)");
        }
        return this.deleteThreadCall(id, _callback);
    }

    public void deleteThread(@Nonnull UUID id) throws ApiException {
        this.deleteThreadWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteThreadWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.deleteThreadValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteThreadAsync(@Nonnull UUID id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteThreadValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getThreadCall(@Nonnull UUID id, @Nullable String fieldsThread, @Nullable String include, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/threads/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fieldsThread != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields[thread]", fieldsThread));
        }
        if (include != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include", include));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getThreadValidateBeforeCall(@Nonnull UUID id, @Nullable String fieldsThread, @Nullable String include, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getThread(Async)");
        }
        return this.getThreadCall(id, fieldsThread, include, _callback);
    }

    public Thread getThread(@Nonnull UUID id, @Nullable String fieldsThread, @Nullable String include) throws ApiException {
        ApiResponse<Thread> localVarResp = this.getThreadWithHttpInfo(id, fieldsThread, include);
        return localVarResp.getData();
    }

    public ApiResponse<Thread> getThreadWithHttpInfo(@Nonnull UUID id, @Nullable String fieldsThread, @Nullable String include) throws ApiException {
        Call localVarCall = this.getThreadValidateBeforeCall(id, fieldsThread, include, null);
        Type localVarReturnType = new TypeToken<Thread>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getThreadAsync(@Nonnull UUID id, @Nullable String fieldsThread, @Nullable String include, ApiCallback<Thread> _callback) throws ApiException {
        Call localVarCall = this.getThreadValidateBeforeCall(id, fieldsThread, include, _callback);
        Type localVarReturnType = new TypeToken<Thread>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getThreadParticipantsCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/threads/{id}/users".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getThreadParticipantsValidateBeforeCall(@Nonnull UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getThreadParticipants(Async)");
        }
        return this.getThreadParticipantsCall(id, _callback);
    }

    public UserList getThreadParticipants(@Nonnull UUID id) throws ApiException {
        ApiResponse<UserList> localVarResp = this.getThreadParticipantsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<UserList> getThreadParticipantsWithHttpInfo(@Nonnull UUID id) throws ApiException {
        Call localVarCall = this.getThreadParticipantsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getThreadParticipantsAsync(@Nonnull UUID id, ApiCallback<UserList> _callback) throws ApiException {
        Call localVarCall = this.getThreadParticipantsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getThreadsCall(@Nullable String fieldsThread, @Nullable String filterCollaborationContextId, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String include, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/threads";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fieldsThread != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields[thread]", fieldsThread));
        }
        if (filterCollaborationContextId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[collaborationContextId]", filterCollaborationContextId));
        }
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if (include != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include", include));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getThreadsValidateBeforeCall(@Nullable String fieldsThread, @Nullable String filterCollaborationContextId, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String include, ApiCallback _callback) throws ApiException {
        return this.getThreadsCall(fieldsThread, filterCollaborationContextId, pageCursor, pageSize, include, _callback);
    }

    public ThreadList getThreads(@Nullable String fieldsThread, @Nullable String filterCollaborationContextId, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String include) throws ApiException {
        ApiResponse<ThreadList> localVarResp = this.getThreadsWithHttpInfo(fieldsThread, filterCollaborationContextId, pageCursor, pageSize, include);
        return localVarResp.getData();
    }

    public ApiResponse<ThreadList> getThreadsWithHttpInfo(@Nullable String fieldsThread, @Nullable String filterCollaborationContextId, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String include) throws ApiException {
        Call localVarCall = this.getThreadsValidateBeforeCall(fieldsThread, filterCollaborationContextId, pageCursor, pageSize, include, null);
        Type localVarReturnType = new TypeToken<ThreadList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getThreadsAsync(@Nullable String fieldsThread, @Nullable String filterCollaborationContextId, @Nullable String pageCursor, @Nullable Integer pageSize, @Nullable String include, ApiCallback<ThreadList> _callback) throws ApiException {
        Call localVarCall = this.getThreadsValidateBeforeCall(fieldsThread, filterCollaborationContextId, pageCursor, pageSize, include, _callback);
        Type localVarReturnType = new TypeToken<ThreadList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateThreadCall(@Nonnull UUID id, @Nonnull UpdateThreadRequest updateThreadRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateThreadRequest localVarPostBody = updateThreadRequest;
        String localVarPath = "/threads/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateThreadValidateBeforeCall(@Nonnull UUID id, @Nonnull UpdateThreadRequest updateThreadRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateThread(Async)");
        }
        if (updateThreadRequest == null) {
            throw new ApiException("Missing the required parameter 'updateThreadRequest' when calling updateThread(Async)");
        }
        return this.updateThreadCall(id, updateThreadRequest, _callback);
    }

    public Thread updateThread(@Nonnull UUID id, @Nonnull UpdateThreadRequest updateThreadRequest) throws ApiException {
        ApiResponse<Thread> localVarResp = this.updateThreadWithHttpInfo(id, updateThreadRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Thread> updateThreadWithHttpInfo(@Nonnull UUID id, @Nonnull UpdateThreadRequest updateThreadRequest) throws ApiException {
        Call localVarCall = this.updateThreadValidateBeforeCall(id, updateThreadRequest, null);
        Type localVarReturnType = new TypeToken<Thread>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateThreadAsync(@Nonnull UUID id, @Nonnull UpdateThreadRequest updateThreadRequest, ApiCallback<Thread> _callback) throws ApiException {
        Call localVarCall = this.updateThreadValidateBeforeCall(id, updateThreadRequest, _callback);
        Type localVarReturnType = new TypeToken<Thread>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

