/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OAuth2Token {
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    @Nonnull
    private String accessToken;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "token_type";
    @SerializedName(value="token_type")
    @Nonnull
    private String tokenType;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    @Nonnull
    private String accountId;
    public static final String SERIALIZED_NAME_EXPIRES_IN = "expires_in";
    @SerializedName(value="expires_in")
    @Nonnull
    private Integer expiresIn;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    @Nonnull
    private List<String> scopes = new ArrayList<String>();
    public static final String SERIALIZED_NAME_REFRESH_TOKEN = "refresh_token";
    @SerializedName(value="refresh_token")
    @Nullable
    private String refreshToken;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("access_token", "token_type", "account_id", "expires_in", "scopes", "refresh_token"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("access_token", "token_type", "account_id", "expires_in", "scopes"));

    public OAuth2Token accessToken(@Nonnull String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nonnull
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(@Nonnull String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuth2Token tokenType(@Nonnull String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nonnull
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(@Nonnull String tokenType) {
        this.tokenType = tokenType;
    }

    public OAuth2Token accountId(@Nonnull String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(@Nonnull String accountId) {
        this.accountId = accountId;
    }

    public OAuth2Token expiresIn(@Nonnull Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nonnull
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(@Nonnull Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public OAuth2Token scopes(@Nonnull List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuth2Token addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nonnull
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(@Nonnull List<String> scopes) {
        this.scopes = scopes;
    }

    public OAuth2Token refreshToken(@Nullable String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(@Nullable String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Token oauth2Token = (OAuth2Token)o;
        return Objects.equals(this.accessToken, oauth2Token.accessToken) && Objects.equals(this.tokenType, oauth2Token.tokenType) && Objects.equals(this.accountId, oauth2Token.accountId) && Objects.equals(this.expiresIn, oauth2Token.expiresIn) && Objects.equals(this.scopes, oauth2Token.scopes) && Objects.equals(this.refreshToken, oauth2Token.refreshToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.accountId, this.expiresIn, this.scopes, this.refreshToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2Token {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OAuth2Token is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OAuth2Token` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_TOKEN).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `token_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_SCOPES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `scopes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFRESH_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_REFRESH_TOKEN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REFRESH_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `refresh_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFRESH_TOKEN).toString()));
        }
    }

    public static OAuth2Token fromJson(String jsonString) throws IOException {
        return (OAuth2Token)JSON.getGson().fromJson(jsonString, OAuth2Token.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OAuth2Token.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OAuth2Token.class));
            return new TypeAdapter<OAuth2Token>(){

                public void write(JsonWriter out, OAuth2Token value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OAuth2Token read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    OAuth2Token.validateJsonElement(jsonElement);
                    return (OAuth2Token)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

