/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.JSON;
import com.vertexvis.model.AbstractOpenApiSchema;
import com.vertexvis.model.QueryAll;
import com.vertexvis.model.QueryByCollection;
import com.vertexvis.model.QueryById;
import com.vertexvis.model.QueryByMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SceneOperationQuery
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(SceneOperationQuery.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public SceneOperationQuery() {
        super("anyOf", Boolean.FALSE);
    }

    public SceneOperationQuery(Object o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof QueryById) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof QueryByCollection) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof QueryAll) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof QueryByMetadata) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be QueryAll, QueryByCollection, QueryById, QueryByMetadata");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public QueryById getQueryById() throws ClassCastException {
        return (QueryById)super.getActualInstance();
    }

    public QueryByCollection getQueryByCollection() throws ClassCastException {
        return (QueryByCollection)super.getActualInstance();
    }

    public QueryAll getQueryAll() throws ClassCastException {
        return (QueryAll)((Object)super.getActualInstance());
    }

    public QueryByMetadata getQueryByMetadata() throws ClassCastException {
        return (QueryByMetadata)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            QueryById.validateJsonElement(jsonElement);
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for QueryById failed with `%s`.", e.getMessage()));
            try {
                QueryByCollection.validateJsonElement(jsonElement);
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format("Deserialization for QueryByCollection failed with `%s`.", e2.getMessage()));
                try {
                    QueryAll.validateJsonElement(jsonElement);
                    return;
                }
                catch (Exception e3) {
                    errorMessages.add(String.format("Deserialization for QueryAll failed with `%s`.", e3.getMessage()));
                    try {
                        QueryByMetadata.validateJsonElement(jsonElement);
                        return;
                    }
                    catch (Exception e4) {
                        errorMessages.add(String.format("Deserialization for QueryByMetadata failed with `%s`.", e4.getMessage()));
                        throw new IOException(String.format("The JSON string is invalid for SceneOperationQuery with anyOf schemas: QueryAll, QueryByCollection, QueryById, QueryByMetadata. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                    }
                }
            }
        }
    }

    public static SceneOperationQuery fromJson(String jsonString) throws IOException {
        return (SceneOperationQuery)JSON.getGson().fromJson(jsonString, SceneOperationQuery.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("QueryById", QueryById.class);
        schemas.put("QueryByCollection", QueryByCollection.class);
        schemas.put("QueryAll", QueryAll.class);
        schemas.put("QueryByMetadata", QueryByMetadata.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SceneOperationQuery.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterQueryById = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(QueryById.class));
            final TypeAdapter adapterQueryByCollection = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(QueryByCollection.class));
            final TypeAdapter adapterQueryAll = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(QueryAll.class));
            final TypeAdapter adapterQueryByMetadata = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(QueryByMetadata.class));
            return new TypeAdapter<SceneOperationQuery>(){

                public void write(JsonWriter out, SceneOperationQuery value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof QueryById) {
                        JsonElement element = adapterQueryById.toJsonTree((Object)((QueryById)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof QueryByCollection) {
                        JsonElement element = adapterQueryByCollection.toJsonTree((Object)((QueryByCollection)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof QueryAll) {
                        JsonElement element = adapterQueryAll.toJsonTree((Object)((QueryAll)((Object)value.getActualInstance())));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof QueryByMetadata) {
                        JsonElement element = adapterQueryByMetadata.toJsonTree((Object)((QueryByMetadata)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemas: QueryAll, QueryByCollection, QueryById, QueryByMetadata");
                }

                public SceneOperationQuery read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        QueryById.validateJsonElement(jsonElement);
                        actualAdapter = adapterQueryById;
                        SceneOperationQuery ret = new SceneOperationQuery();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for QueryById failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'QueryById'", e);
                        try {
                            QueryByCollection.validateJsonElement(jsonElement);
                            actualAdapter = adapterQueryByCollection;
                            SceneOperationQuery ret = new SceneOperationQuery();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format("Deserialization for QueryByCollection failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'QueryByCollection'", e2);
                            try {
                                QueryAll.validateJsonElement(jsonElement);
                                actualAdapter = adapterQueryAll;
                                SceneOperationQuery ret = new SceneOperationQuery();
                                ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                                return ret;
                            }
                            catch (Exception e3) {
                                errorMessages.add(String.format("Deserialization for QueryAll failed with `%s`.", e3.getMessage()));
                                log.log(Level.FINER, "Input data does not match schema 'QueryAll'", e3);
                                try {
                                    QueryByMetadata.validateJsonElement(jsonElement);
                                    actualAdapter = adapterQueryByMetadata;
                                    SceneOperationQuery ret = new SceneOperationQuery();
                                    ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                                    return ret;
                                }
                                catch (Exception e4) {
                                    errorMessages.add(String.format("Deserialization for QueryByMetadata failed with `%s`.", e4.getMessage()));
                                    log.log(Level.FINER, "Input data does not match schema 'QueryByMetadata'", e4);
                                    throw new IOException(String.format("Failed deserialization for SceneOperationQuery: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                                }
                            }
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

