/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.JSON;
import com.vertexvis.model.Link;
import com.vertexvis.model.UserDataAttributes;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserData {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nonnull
    private UUID id;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    @Nonnull
    private UserDataAttributes attributes;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    @Nullable
    private Map<String, Link> links = new HashMap<String, Link>();
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("id", "attributes", "links"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("id", "attributes"));

    public UserData id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public UserData attributes(@Nonnull UserDataAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nonnull
    public UserDataAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nonnull UserDataAttributes attributes) {
        this.attributes = attributes;
    }

    public UserData links(@Nullable Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public UserData putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(@Nullable Map<String, Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserData userData = (UserData)o;
        return Objects.equals(this.id, userData.id) && Objects.equals(this.attributes, userData.attributes) && Objects.equals(this.links, userData.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.attributes, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserData {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in UserData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UserData` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        UserDataAttributes.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ATTRIBUTES));
    }

    public static UserData fromJson(String jsonString) throws IOException {
        return (UserData)JSON.getGson().fromJson(jsonString, UserData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UserData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UserData.class));
            return new TypeAdapter<UserData>(){

                public void write(JsonWriter out, UserData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UserData read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    UserData.validateJsonElement(jsonElement);
                    return (UserData)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

