/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.JSON;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WebhookSubscriptionDataAttributes {
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    @Nonnull
    private String url;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    @Nullable
    private String secret;
    public static final String SERIALIZED_NAME_TOPICS = "topics";
    @SerializedName(value="topics")
    @Nonnull
    private List<String> topics = new ArrayList<String>();
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nonnull
    private StatusEnum status;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    @Nonnull
    private OffsetDateTime created;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("url", "secret", "topics", "status", "created"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("url", "topics", "status", "created"));

    public WebhookSubscriptionDataAttributes url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    public WebhookSubscriptionDataAttributes secret(@Nullable String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(@Nullable String secret) {
        this.secret = secret;
    }

    public WebhookSubscriptionDataAttributes topics(@Nonnull List<String> topics) {
        this.topics = topics;
        return this;
    }

    public WebhookSubscriptionDataAttributes addTopicsItem(String topicsItem) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.add(topicsItem);
        return this;
    }

    @Nonnull
    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(@Nonnull List<String> topics) {
        this.topics = topics;
    }

    public WebhookSubscriptionDataAttributes status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public WebhookSubscriptionDataAttributes created(@Nonnull OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nonnull
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(@Nonnull OffsetDateTime created) {
        this.created = created;
    }

    public WebhookSubscriptionDataAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookSubscriptionDataAttributes webhookSubscriptionDataAttributes = (WebhookSubscriptionDataAttributes)o;
        return Objects.equals(this.url, webhookSubscriptionDataAttributes.url) && Objects.equals(this.secret, webhookSubscriptionDataAttributes.secret) && Objects.equals(this.topics, webhookSubscriptionDataAttributes.topics) && Objects.equals((Object)this.status, (Object)webhookSubscriptionDataAttributes.status) && Objects.equals(this.created, webhookSubscriptionDataAttributes.created) && Objects.equals(this.additionalProperties, webhookSubscriptionDataAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.secret, this.topics, this.status, this.created, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookSubscriptionDataAttributes {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in WebhookSubscriptionDataAttributes is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET) != null && !jsonObj.get(SERIALIZED_NAME_SECRET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECRET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secret` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOPICS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TOPICS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `topics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOPICS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        StatusEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
    }

    public static WebhookSubscriptionDataAttributes fromJson(String jsonString) throws IOException {
        return (WebhookSubscriptionDataAttributes)JSON.getGson().fromJson(jsonString, WebhookSubscriptionDataAttributes.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        PAUSED("paused");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            StatusEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WebhookSubscriptionDataAttributes.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WebhookSubscriptionDataAttributes.class));
            return new TypeAdapter<WebhookSubscriptionDataAttributes>(){

                public void write(JsonWriter out, WebhookSubscriptionDataAttributes value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WebhookSubscriptionDataAttributes read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    WebhookSubscriptionDataAttributes.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    WebhookSubscriptionDataAttributes instance = (WebhookSubscriptionDataAttributes)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

