/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples,   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.api;

import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.ProgressRequestBody;
import com.vertexvis.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.vertexvis.model.CreateWebhookSubscriptionRequest;
import com.vertexvis.model.Failure;
import com.vertexvis.model.WebhookSubscription;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebhookSubscriptionsApi {
    private ApiClient localVarApiClient;

    public WebhookSubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebhookSubscriptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createWebhookSubscription
     * @param createWebhookSubscriptionRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createWebhookSubscriptionCall(CreateWebhookSubscriptionRequest createWebhookSubscriptionRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createWebhookSubscriptionRequest;

        // create path and map variables
        String localVarPath = "/webhook-subscriptions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/vnd.api+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createWebhookSubscriptionValidateBeforeCall(CreateWebhookSubscriptionRequest createWebhookSubscriptionRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'createWebhookSubscriptionRequest' is set
        if (createWebhookSubscriptionRequest == null) {
            throw new ApiException("Missing the required parameter 'createWebhookSubscriptionRequest' when calling createWebhookSubscription(Async)");
        }
        

        okhttp3.Call localVarCall = createWebhookSubscriptionCall(createWebhookSubscriptionRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Create a &#x60;webhook-subscription&#x60;
     * @param createWebhookSubscriptionRequest  (required)
     * @return WebhookSubscription
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public WebhookSubscription createWebhookSubscription(CreateWebhookSubscriptionRequest createWebhookSubscriptionRequest) throws ApiException {
        ApiResponse<WebhookSubscription> localVarResp = createWebhookSubscriptionWithHttpInfo(createWebhookSubscriptionRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * Create a &#x60;webhook-subscription&#x60;
     * @param createWebhookSubscriptionRequest  (required)
     * @return ApiResponse&lt;WebhookSubscription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WebhookSubscription> createWebhookSubscriptionWithHttpInfo(CreateWebhookSubscriptionRequest createWebhookSubscriptionRequest) throws ApiException {
        okhttp3.Call localVarCall = createWebhookSubscriptionValidateBeforeCall(createWebhookSubscriptionRequest, null);
        Type localVarReturnType = new TypeToken<WebhookSubscription>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Create a &#x60;webhook-subscription&#x60;
     * @param createWebhookSubscriptionRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createWebhookSubscriptionAsync(CreateWebhookSubscriptionRequest createWebhookSubscriptionRequest, final ApiCallback<WebhookSubscription> _callback) throws ApiException {

        okhttp3.Call localVarCall = createWebhookSubscriptionValidateBeforeCall(createWebhookSubscriptionRequest, _callback);
        Type localVarReturnType = new TypeToken<WebhookSubscription>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
