/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebhookSubscriptionDataAttributes {
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_TOPICS = "topics";
    @SerializedName(value="topics")
    private List<String> topics = new ArrayList<String>();
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;

    public WebhookSubscriptionDataAttributes url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WebhookSubscriptionDataAttributes secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(example="i3MFRDOmg1pxD36dGCTONRwOujkgV8m9LQ", required=true, value="")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WebhookSubscriptionDataAttributes topics(List<String> topics) {
        this.topics = topics;
        return this;
    }

    public WebhookSubscriptionDataAttributes addTopicsItem(String topicsItem) {
        this.topics.add(topicsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public WebhookSubscriptionDataAttributes status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="active", required=true, value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public WebhookSubscriptionDataAttributes created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(example="2020-01-01T12:00Z", required=true, value="")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookSubscriptionDataAttributes webhookSubscriptionDataAttributes = (WebhookSubscriptionDataAttributes)o;
        return Objects.equals(this.url, webhookSubscriptionDataAttributes.url) && Objects.equals(this.secret, webhookSubscriptionDataAttributes.secret) && Objects.equals(this.topics, webhookSubscriptionDataAttributes.topics) && Objects.equals((Object)this.status, (Object)webhookSubscriptionDataAttributes.status) && Objects.equals(this.created, webhookSubscriptionDataAttributes.created);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.secret, this.topics, this.status, this.created});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookSubscriptionDataAttributes {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        PAUSED("paused");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

