/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples,   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.api;

import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.ProgressRequestBody;
import com.vertexvis.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.vertexvis.model.OAuth2BadRequest;
import com.vertexvis.model.OAuth2Token;
import com.vertexvis.model.RevokeOAuth2TokenRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Oauth2Api {
    private ApiClient localVarApiClient;

    public Oauth2Api() {
        this(Configuration.getDefaultApiClient());
    }

    public Oauth2Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createToken
     * @param grantType  (required)
     * @param scope  (optional)
     * @param code  (optional)
     * @param redirectUri  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid or missing request. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTokenCall(String grantType, String scope, String code, String redirectUri, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/oauth2/token";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (scope != null) {
            localVarFormParams.put("scope", scope);
        }

        if (code != null) {
            localVarFormParams.put("code", code);
        }

        if (redirectUri != null) {
            localVarFormParams.put("redirect_uri", redirectUri);
        }

        if (grantType != null) {
            localVarFormParams.put("grant_type", grantType);
        }

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/x-www-form-urlencoded"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTokenValidateBeforeCall(String grantType, String scope, String code, String redirectUri, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'grantType' is set
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling createToken(Async)");
        }
        

        okhttp3.Call localVarCall = createTokenCall(grantType, scope, code, redirectUri, _callback);
        return localVarCall;

    }

    /**
     * 
     * Create an OAuth2 access token. For details, see our [Authentication](https://developer.vertexvis.com/docs/guides/authentication) guide.
     * @param grantType  (required)
     * @param scope  (optional)
     * @param code  (optional)
     * @param redirectUri  (optional)
     * @return OAuth2Token
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid or missing request. </td><td>  -  </td></tr>
     </table>
     */
    public OAuth2Token createToken(String grantType, String scope, String code, String redirectUri) throws ApiException {
        ApiResponse<OAuth2Token> localVarResp = createTokenWithHttpInfo(grantType, scope, code, redirectUri);
        return localVarResp.getData();
    }

    /**
     * 
     * Create an OAuth2 access token. For details, see our [Authentication](https://developer.vertexvis.com/docs/guides/authentication) guide.
     * @param grantType  (required)
     * @param scope  (optional)
     * @param code  (optional)
     * @param redirectUri  (optional)
     * @return ApiResponse&lt;OAuth2Token&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid or missing request. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OAuth2Token> createTokenWithHttpInfo(String grantType, String scope, String code, String redirectUri) throws ApiException {
        okhttp3.Call localVarCall = createTokenValidateBeforeCall(grantType, scope, code, redirectUri, null);
        Type localVarReturnType = new TypeToken<OAuth2Token>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Create an OAuth2 access token. For details, see our [Authentication](https://developer.vertexvis.com/docs/guides/authentication) guide.
     * @param grantType  (required)
     * @param scope  (optional)
     * @param code  (optional)
     * @param redirectUri  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid or missing request. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTokenAsync(String grantType, String scope, String code, String redirectUri, final ApiCallback<OAuth2Token> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTokenValidateBeforeCall(grantType, scope, code, redirectUri, _callback);
        Type localVarReturnType = new TypeToken<OAuth2Token>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for revokeToken
     * @param revokeOAuth2TokenRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeTokenCall(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = revokeOAuth2TokenRequest;

        // create path and map variables
        String localVarPath = "/oauth2/revoke";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/vnd.api+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call revokeTokenValidateBeforeCall(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'revokeOAuth2TokenRequest' is set
        if (revokeOAuth2TokenRequest == null) {
            throw new ApiException("Missing the required parameter 'revokeOAuth2TokenRequest' when calling revokeToken(Async)");
        }
        

        okhttp3.Call localVarCall = revokeTokenCall(revokeOAuth2TokenRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Revoke an OAuth2 access token.
     * @param revokeOAuth2TokenRequest  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void revokeToken(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest) throws ApiException {
        revokeTokenWithHttpInfo(revokeOAuth2TokenRequest);
    }

    /**
     * 
     * Revoke an OAuth2 access token.
     * @param revokeOAuth2TokenRequest  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> revokeTokenWithHttpInfo(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest) throws ApiException {
        okhttp3.Call localVarCall = revokeTokenValidateBeforeCall(revokeOAuth2TokenRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Revoke an OAuth2 access token.
     * @param revokeOAuth2TokenRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeTokenAsync(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = revokeTokenValidateBeforeCall(revokeOAuth2TokenRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
