/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples,   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.model.AnyOfGeometrySetRelationshipPartRevisionRelationshipSceneRelationship;
import com.vertexvis.model.SceneItemRelationship;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * CreateSceneItemRequestDataRelationships
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CreateSceneItemRequestDataRelationships {
  public static final String SERIALIZED_NAME_PARENT = "parent";
  @SerializedName(SERIALIZED_NAME_PARENT)
  private SceneItemRelationship parent;

  public static final String SERIALIZED_NAME_SOURCE = "source";
  @SerializedName(SERIALIZED_NAME_SOURCE)
  private AnyOfGeometrySetRelationshipPartRevisionRelationshipSceneRelationship source;


  public CreateSceneItemRequestDataRelationships parent(SceneItemRelationship parent) {
    
    this.parent = parent;
    return this;
  }

   /**
   * Get parent
   * @return parent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public SceneItemRelationship getParent() {
    return parent;
  }


  public void setParent(SceneItemRelationship parent) {
    this.parent = parent;
  }


  public CreateSceneItemRequestDataRelationships source(AnyOfGeometrySetRelationshipPartRevisionRelationshipSceneRelationship source) {
    
    this.source = source;
    return this;
  }

   /**
   * Relationship to a &#x60;geometry-set&#x60;, &#x60;part-revision&#x60;, or &#x60;scene&#x60;.
   * @return source
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Relationship to a `geometry-set`, `part-revision`, or `scene`.")

  public AnyOfGeometrySetRelationshipPartRevisionRelationshipSceneRelationship getSource() {
    return source;
  }


  public void setSource(AnyOfGeometrySetRelationshipPartRevisionRelationshipSceneRelationship source) {
    this.source = source;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateSceneItemRequestDataRelationships createSceneItemRequestDataRelationships = (CreateSceneItemRequestDataRelationships) o;
    return Objects.equals(this.parent, createSceneItemRequestDataRelationships.parent) &&
        Objects.equals(this.source, createSceneItemRequestDataRelationships.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parent, source);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateSceneItemRequestDataRelationships {\n");
    sb.append("    parent: ").append(toIndentedString(parent)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

