/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.OAuth2Token;
import com.vertexvis.model.RevokeOAuth2TokenRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class Oauth2Api {
    private ApiClient localVarApiClient;

    public Oauth2Api() {
        this(Configuration.getDefaultApiClient());
    }

    public Oauth2Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createTokenCall(String grantType, String scope, String code, String redirectUri, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (scope != null) {
            localVarFormParams.put("scope", scope);
        }
        if (code != null) {
            localVarFormParams.put("code", code);
        }
        if (redirectUri != null) {
            localVarFormParams.put("redirect_uri", redirectUri);
        }
        if (grantType != null) {
            localVarFormParams.put("grant_type", grantType);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTokenValidateBeforeCall(String grantType, String scope, String code, String redirectUri, ApiCallback _callback) throws ApiException {
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling createToken(Async)");
        }
        Call localVarCall = this.createTokenCall(grantType, scope, code, redirectUri, _callback);
        return localVarCall;
    }

    public OAuth2Token createToken(String grantType, String scope, String code, String redirectUri) throws ApiException {
        ApiResponse<OAuth2Token> localVarResp = this.createTokenWithHttpInfo(grantType, scope, code, redirectUri);
        return localVarResp.getData();
    }

    public ApiResponse<OAuth2Token> createTokenWithHttpInfo(String grantType, String scope, String code, String redirectUri) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(grantType, scope, code, redirectUri, null);
        Type localVarReturnType = new TypeToken<OAuth2Token>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTokenAsync(String grantType, String scope, String code, String redirectUri, ApiCallback<OAuth2Token> _callback) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(grantType, scope, code, redirectUri, _callback);
        Type localVarReturnType = new TypeToken<OAuth2Token>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call revokeTokenCall(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest, ApiCallback _callback) throws ApiException {
        RevokeOAuth2TokenRequest localVarPostBody = revokeOAuth2TokenRequest;
        String localVarPath = "/oauth2/revoke";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeTokenValidateBeforeCall(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest, ApiCallback _callback) throws ApiException {
        if (revokeOAuth2TokenRequest == null) {
            throw new ApiException("Missing the required parameter 'revokeOAuth2TokenRequest' when calling revokeToken(Async)");
        }
        Call localVarCall = this.revokeTokenCall(revokeOAuth2TokenRequest, _callback);
        return localVarCall;
    }

    public void revokeToken(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest) throws ApiException {
        this.revokeTokenWithHttpInfo(revokeOAuth2TokenRequest);
    }

    public ApiResponse<Void> revokeTokenWithHttpInfo(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest) throws ApiException {
        Call localVarCall = this.revokeTokenValidateBeforeCall(revokeOAuth2TokenRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call revokeTokenAsync(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revokeTokenValidateBeforeCall(revokeOAuth2TokenRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

