/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateSceneViewRequest;
import com.vertexvis.model.SceneView;
import com.vertexvis.model.SceneViewItem;
import com.vertexvis.model.SceneViewList;
import com.vertexvis.model.UpdateSceneViewRequest;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class SceneViewsApi {
    private ApiClient localVarApiClient;

    public SceneViewsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SceneViewsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createSceneViewCall(UUID id, CreateSceneViewRequest createSceneViewRequest, ApiCallback _callback) throws ApiException {
        CreateSceneViewRequest localVarPostBody = createSceneViewRequest;
        String localVarPath = "/scenes/{id}/scene-views".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSceneViewValidateBeforeCall(UUID id, CreateSceneViewRequest createSceneViewRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createSceneView(Async)");
        }
        if (createSceneViewRequest == null) {
            throw new ApiException("Missing the required parameter 'createSceneViewRequest' when calling createSceneView(Async)");
        }
        Call localVarCall = this.createSceneViewCall(id, createSceneViewRequest, _callback);
        return localVarCall;
    }

    public SceneView createSceneView(UUID id, CreateSceneViewRequest createSceneViewRequest) throws ApiException {
        ApiResponse<SceneView> localVarResp = this.createSceneViewWithHttpInfo(id, createSceneViewRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SceneView> createSceneViewWithHttpInfo(UUID id, CreateSceneViewRequest createSceneViewRequest) throws ApiException {
        Call localVarCall = this.createSceneViewValidateBeforeCall(id, createSceneViewRequest, null);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSceneViewAsync(UUID id, CreateSceneViewRequest createSceneViewRequest, ApiCallback<SceneView> _callback) throws ApiException {
        Call localVarCall = this.createSceneViewValidateBeforeCall(id, createSceneViewRequest, _callback);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSceneViewCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scene-views/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSceneViewValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteSceneView(Async)");
        }
        Call localVarCall = this.deleteSceneViewCall(id, _callback);
        return localVarCall;
    }

    public void deleteSceneView(UUID id) throws ApiException {
        this.deleteSceneViewWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteSceneViewWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.deleteSceneViewValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSceneViewAsync(UUID id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSceneViewValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getSceneViewCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scene-views/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSceneViewValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSceneView(Async)");
        }
        Call localVarCall = this.getSceneViewCall(id, _callback);
        return localVarCall;
    }

    public SceneView getSceneView(UUID id) throws ApiException {
        ApiResponse<SceneView> localVarResp = this.getSceneViewWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<SceneView> getSceneViewWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getSceneViewValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSceneViewAsync(UUID id, ApiCallback<SceneView> _callback) throws ApiException {
        Call localVarCall = this.getSceneViewValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSceneViewsCall(UUID id, String pageCursor, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/scenes/{id}/scene-views".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSceneViewsValidateBeforeCall(UUID id, String pageCursor, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSceneViews(Async)");
        }
        Call localVarCall = this.getSceneViewsCall(id, pageCursor, pageSize, _callback);
        return localVarCall;
    }

    public SceneViewList getSceneViews(UUID id, String pageCursor, Integer pageSize) throws ApiException {
        ApiResponse<SceneViewList> localVarResp = this.getSceneViewsWithHttpInfo(id, pageCursor, pageSize);
        return localVarResp.getData();
    }

    public ApiResponse<SceneViewList> getSceneViewsWithHttpInfo(UUID id, String pageCursor, Integer pageSize) throws ApiException {
        Call localVarCall = this.getSceneViewsValidateBeforeCall(id, pageCursor, pageSize, null);
        Type localVarReturnType = new TypeToken<SceneViewList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSceneViewsAsync(UUID id, String pageCursor, Integer pageSize, ApiCallback<SceneViewList> _callback) throws ApiException {
        Call localVarCall = this.getSceneViewsValidateBeforeCall(id, pageCursor, pageSize, _callback);
        Type localVarReturnType = new TypeToken<SceneViewList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getViewSceneItemCall(UUID id, UUID itemId, String fieldsSceneItem, String include, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/scene-views/{id}/scene-items/{itemId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{itemId\\}", this.localVarApiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fieldsSceneItem != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields[scene-item]", fieldsSceneItem));
        }
        if (include != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include", include));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getViewSceneItemValidateBeforeCall(UUID id, UUID itemId, String fieldsSceneItem, String include, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getViewSceneItem(Async)");
        }
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling getViewSceneItem(Async)");
        }
        Call localVarCall = this.getViewSceneItemCall(id, itemId, fieldsSceneItem, include, _callback);
        return localVarCall;
    }

    public SceneViewItem getViewSceneItem(UUID id, UUID itemId, String fieldsSceneItem, String include) throws ApiException {
        ApiResponse<SceneViewItem> localVarResp = this.getViewSceneItemWithHttpInfo(id, itemId, fieldsSceneItem, include);
        return localVarResp.getData();
    }

    public ApiResponse<SceneViewItem> getViewSceneItemWithHttpInfo(UUID id, UUID itemId, String fieldsSceneItem, String include) throws ApiException {
        Call localVarCall = this.getViewSceneItemValidateBeforeCall(id, itemId, fieldsSceneItem, include, null);
        Type localVarReturnType = new TypeToken<SceneViewItem>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getViewSceneItemAsync(UUID id, UUID itemId, String fieldsSceneItem, String include, ApiCallback<SceneViewItem> _callback) throws ApiException {
        Call localVarCall = this.getViewSceneItemValidateBeforeCall(id, itemId, fieldsSceneItem, include, _callback);
        Type localVarReturnType = new TypeToken<SceneViewItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call renderSceneViewCall(UUID id, Integer height, Integer width, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/scene-views/{id}/image".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (height != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("height", height));
        }
        if (width != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("width", width));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"image/jpeg", "application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call renderSceneViewValidateBeforeCall(UUID id, Integer height, Integer width, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling renderSceneView(Async)");
        }
        Call localVarCall = this.renderSceneViewCall(id, height, width, _callback);
        return localVarCall;
    }

    public File renderSceneView(UUID id, Integer height, Integer width) throws ApiException {
        ApiResponse<File> localVarResp = this.renderSceneViewWithHttpInfo(id, height, width);
        return localVarResp.getData();
    }

    public ApiResponse<File> renderSceneViewWithHttpInfo(UUID id, Integer height, Integer width) throws ApiException {
        Call localVarCall = this.renderSceneViewValidateBeforeCall(id, height, width, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call renderSceneViewAsync(UUID id, Integer height, Integer width, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.renderSceneViewValidateBeforeCall(id, height, width, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSceneViewCall(UUID id, UpdateSceneViewRequest updateSceneViewRequest, ApiCallback _callback) throws ApiException {
        UpdateSceneViewRequest localVarPostBody = updateSceneViewRequest;
        String localVarPath = "/scene-views/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSceneViewValidateBeforeCall(UUID id, UpdateSceneViewRequest updateSceneViewRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSceneView(Async)");
        }
        if (updateSceneViewRequest == null) {
            throw new ApiException("Missing the required parameter 'updateSceneViewRequest' when calling updateSceneView(Async)");
        }
        Call localVarCall = this.updateSceneViewCall(id, updateSceneViewRequest, _callback);
        return localVarCall;
    }

    public SceneView updateSceneView(UUID id, UpdateSceneViewRequest updateSceneViewRequest) throws ApiException {
        ApiResponse<SceneView> localVarResp = this.updateSceneViewWithHttpInfo(id, updateSceneViewRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SceneView> updateSceneViewWithHttpInfo(UUID id, UpdateSceneViewRequest updateSceneViewRequest) throws ApiException {
        Call localVarCall = this.updateSceneViewValidateBeforeCall(id, updateSceneViewRequest, null);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSceneViewAsync(UUID id, UpdateSceneViewRequest updateSceneViewRequest, ApiCallback<SceneView> _callback) throws ApiException {
        Call localVarCall = this.updateSceneViewValidateBeforeCall(id, updateSceneViewRequest, _callback);
        Type localVarReturnType = new TypeToken<SceneView>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

