/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateSceneRequest;
import com.vertexvis.model.QueuedJob;
import com.vertexvis.model.Scene;
import com.vertexvis.model.SceneList;
import com.vertexvis.model.UpdateSceneRequest;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class ScenesApi {
    private ApiClient localVarApiClient;

    public ScenesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScenesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createSceneCall(CreateSceneRequest createSceneRequest, ApiCallback _callback) throws ApiException {
        CreateSceneRequest localVarPostBody = createSceneRequest;
        String localVarPath = "/scenes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSceneValidateBeforeCall(CreateSceneRequest createSceneRequest, ApiCallback _callback) throws ApiException {
        if (createSceneRequest == null) {
            throw new ApiException("Missing the required parameter 'createSceneRequest' when calling createScene(Async)");
        }
        Call localVarCall = this.createSceneCall(createSceneRequest, _callback);
        return localVarCall;
    }

    public Scene createScene(CreateSceneRequest createSceneRequest) throws ApiException {
        ApiResponse<Scene> localVarResp = this.createSceneWithHttpInfo(createSceneRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Scene> createSceneWithHttpInfo(CreateSceneRequest createSceneRequest) throws ApiException {
        Call localVarCall = this.createSceneValidateBeforeCall(createSceneRequest, null);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSceneAsync(CreateSceneRequest createSceneRequest, ApiCallback<Scene> _callback) throws ApiException {
        Call localVarCall = this.createSceneValidateBeforeCall(createSceneRequest, _callback);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSceneCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scenes/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSceneValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteScene(Async)");
        }
        Call localVarCall = this.deleteSceneCall(id, _callback);
        return localVarCall;
    }

    public void deleteScene(UUID id) throws ApiException {
        this.deleteSceneWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteSceneWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.deleteSceneValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSceneAsync(UUID id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSceneValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getQueuedSceneCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/queued-scenes/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedSceneValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedScene(Async)");
        }
        Call localVarCall = this.getQueuedSceneCall(id, _callback);
        return localVarCall;
    }

    public QueuedJob getQueuedScene(UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedSceneWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedSceneWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getQueuedSceneValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedSceneAsync(UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedSceneValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSceneCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scenes/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSceneValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getScene(Async)");
        }
        Call localVarCall = this.getSceneCall(id, _callback);
        return localVarCall;
    }

    public Scene getScene(UUID id) throws ApiException {
        ApiResponse<Scene> localVarResp = this.getSceneWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Scene> getSceneWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getSceneValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSceneAsync(UUID id, ApiCallback<Scene> _callback) throws ApiException {
        Call localVarCall = this.getSceneValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getScenesCall(String pageCursor, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/scenes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getScenesValidateBeforeCall(String pageCursor, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getScenesCall(pageCursor, pageSize, _callback);
        return localVarCall;
    }

    public SceneList getScenes(String pageCursor, Integer pageSize) throws ApiException {
        ApiResponse<SceneList> localVarResp = this.getScenesWithHttpInfo(pageCursor, pageSize);
        return localVarResp.getData();
    }

    public ApiResponse<SceneList> getScenesWithHttpInfo(String pageCursor, Integer pageSize) throws ApiException {
        Call localVarCall = this.getScenesValidateBeforeCall(pageCursor, pageSize, null);
        Type localVarReturnType = new TypeToken<SceneList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getScenesAsync(String pageCursor, Integer pageSize, ApiCallback<SceneList> _callback) throws ApiException {
        Call localVarCall = this.getScenesValidateBeforeCall(pageCursor, pageSize, _callback);
        Type localVarReturnType = new TypeToken<SceneList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call renderSceneCall(UUID id, Integer height, Integer width, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/scenes/{id}/image".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (height != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("height", height));
        }
        if (width != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("width", width));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"image/jpeg", "application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call renderSceneValidateBeforeCall(UUID id, Integer height, Integer width, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling renderScene(Async)");
        }
        Call localVarCall = this.renderSceneCall(id, height, width, _callback);
        return localVarCall;
    }

    public File renderScene(UUID id, Integer height, Integer width) throws ApiException {
        ApiResponse<File> localVarResp = this.renderSceneWithHttpInfo(id, height, width);
        return localVarResp.getData();
    }

    public ApiResponse<File> renderSceneWithHttpInfo(UUID id, Integer height, Integer width) throws ApiException {
        Call localVarCall = this.renderSceneValidateBeforeCall(id, height, width, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call renderSceneAsync(UUID id, Integer height, Integer width, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.renderSceneValidateBeforeCall(id, height, width, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSceneCall(UUID id, UpdateSceneRequest updateSceneRequest, ApiCallback _callback) throws ApiException {
        UpdateSceneRequest localVarPostBody = updateSceneRequest;
        String localVarPath = "/scenes/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSceneValidateBeforeCall(UUID id, UpdateSceneRequest updateSceneRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateScene(Async)");
        }
        if (updateSceneRequest == null) {
            throw new ApiException("Missing the required parameter 'updateSceneRequest' when calling updateScene(Async)");
        }
        Call localVarCall = this.updateSceneCall(id, updateSceneRequest, _callback);
        return localVarCall;
    }

    public Scene updateScene(UUID id, UpdateSceneRequest updateSceneRequest) throws ApiException {
        ApiResponse<Scene> localVarResp = this.updateSceneWithHttpInfo(id, updateSceneRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Scene> updateSceneWithHttpInfo(UUID id, UpdateSceneRequest updateSceneRequest) throws ApiException {
        Call localVarCall = this.updateSceneValidateBeforeCall(id, updateSceneRequest, null);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSceneAsync(UUID id, UpdateSceneRequest updateSceneRequest, ApiCallback<Scene> _callback) throws ApiException {
        Call localVarCall = this.updateSceneValidateBeforeCall(id, updateSceneRequest, _callback);
        Type localVarReturnType = new TypeToken<Scene>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

