/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.example;

import com.vertexvis.model.QueuedJob;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class JobPoller {
    private static final long DEFAULT_WAIT_TIME_MS = 3000L;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(4);

    JobPoller() {
    }

    public static CompletableFuture<UUID> pollUntilJobDoneAsync(String type, Supplier<CompletableFuture<QueuedJob>> f) {
        CompletableFuture<UUID> cf = new CompletableFuture<UUID>();
        JobPoller.startChecking(cf, type, f);
        return cf;
    }

    public static UUID pollUntilJobDone(String type, Supplier<QueuedJob> f) throws InterruptedException {
        Thread.sleep(3000L);
        QueuedJob qj = f.get();
        if (qj.getData().getType().equals(type)) {
            return qj.getData().getId();
        }
        return JobPoller.pollUntilJobDone(type, f);
    }

    private static void startChecking(CompletableFuture<UUID> resultF, String type, Supplier<CompletableFuture<QueuedJob>> f) {
        scheduler.schedule(() -> ((CompletableFuture)f.get()).thenAccept(arg_0 -> JobPoller.lambda$null$0(type, resultF, (Supplier)f, arg_0)), 3000L, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void lambda$null$0(String type, CompletableFuture resultF, Supplier f, QueuedJob qj) {
        if (qj.getData().getType().equals(type)) {
            resultF.complete(qj.getData().getId());
        } else {
            JobPoller.startChecking(resultF, type, f);
        }
    }
}

