/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples,   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * 4D vector.
 */
@ApiModel(description = "4D vector.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Vector4 {
  public static final String SERIALIZED_NAME_X = "x";
  @SerializedName(SERIALIZED_NAME_X)
  private BigDecimal x;

  public static final String SERIALIZED_NAME_Y = "y";
  @SerializedName(SERIALIZED_NAME_Y)
  private BigDecimal y;

  public static final String SERIALIZED_NAME_Z = "z";
  @SerializedName(SERIALIZED_NAME_Z)
  private BigDecimal z;

  public static final String SERIALIZED_NAME_W = "w";
  @SerializedName(SERIALIZED_NAME_W)
  private BigDecimal w;


  public Vector4 x(BigDecimal x) {
    
    this.x = x;
    return this;
  }

   /**
   * x-axis coordinate.
   * @return x
  **/
  @ApiModelProperty(example = "1.0", required = true, value = "x-axis coordinate.")

  public BigDecimal getX() {
    return x;
  }


  public void setX(BigDecimal x) {
    this.x = x;
  }


  public Vector4 y(BigDecimal y) {
    
    this.y = y;
    return this;
  }

   /**
   * y-axis coordinate.
   * @return y
  **/
  @ApiModelProperty(example = "0.0", required = true, value = "y-axis coordinate.")

  public BigDecimal getY() {
    return y;
  }


  public void setY(BigDecimal y) {
    this.y = y;
  }


  public Vector4 z(BigDecimal z) {
    
    this.z = z;
    return this;
  }

   /**
   * z-axis coordinate.
   * @return z
  **/
  @ApiModelProperty(example = "0.0", required = true, value = "z-axis coordinate.")

  public BigDecimal getZ() {
    return z;
  }


  public void setZ(BigDecimal z) {
    this.z = z;
  }


  public Vector4 w(BigDecimal w) {
    
    this.w = w;
    return this;
  }

   /**
   * w value.
   * @return w
  **/
  @ApiModelProperty(example = "0.0", required = true, value = "w value.")

  public BigDecimal getW() {
    return w;
  }


  public void setW(BigDecimal w) {
    this.w = w;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Vector4 vector4 = (Vector4) o;
    return Objects.equals(this.x, vector4.x) &&
        Objects.equals(this.y, vector4.y) &&
        Objects.equals(this.z, vector4.z) &&
        Objects.equals(this.w, vector4.w);
  }

  @Override
  public int hashCode() {
    return Objects.hash(x, y, z, w);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Vector4 {\n");
    sb.append("    x: ").append(toIndentedString(x)).append("\n");
    sb.append("    y: ").append(toIndentedString(y)).append("\n");
    sb.append("    z: ").append(toIndentedString(z)).append("\n");
    sb.append("    w: ").append(toIndentedString(w)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

