/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.auth;

import com.vertexvis.Pair;
import com.vertexvis.auth.OAuth;
import com.vertexvis.auth.OAuthFlow;
import com.vertexvis.auth.OAuthOkHttpClient;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.jetbrains.annotations.NotNull;

public class RetryingOAuth
extends OAuth
implements Interceptor {
    private final OAuthClient oAuthClient;
    private final OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;

    public RetryingOAuth(String tokenUrl, String clientId, OAuthFlow flow, String clientSecret, Map<String, String> parameters) {
        this.oAuthClient = new OAuthClient((HttpClient)new OAuthOkHttpClient(new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthInterceptor(clientId, clientSecret)).build()));
        this.tokenRequestBuilder = OAuthClientRequest.tokenLocation((String)tokenUrl);
        this.setFlow(flow);
        if (parameters != null) {
            for (String paramName : parameters.keySet()) {
                this.tokenRequestBuilder.setParameter(paramName, parameters.get(paramName));
            }
        }
    }

    public void setFlow(OAuthFlow flow) {
        if (flow == OAuthFlow.application) {
            this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
        }
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.retryingIntercept(chain, true);
    }

    private Response retryingIntercept(Interceptor.Chain chain, boolean updateTokenAndRetryOnAuthorizationFailure) throws IOException {
        Request request = chain.request();
        if (request.header("Authorization") != null) {
            return chain.proceed(request);
        }
        if (this.getAccessToken() == null) {
            this.updateAccessToken(null);
        }
        if (this.getAccessToken() != null) {
            OAuthClientRequest oAuthRequest;
            Request.Builder requestBuilder = request.newBuilder();
            String requestAccessToken = this.getAccessToken();
            try {
                oAuthRequest = new OAuthBearerClientRequest(request.url().toString()).setAccessToken(requestAccessToken).buildHeaderMessage();
            }
            catch (OAuthSystemException e) {
                throw new IOException(e);
            }
            Map headers = oAuthRequest.getHeaders();
            for (String headerName : headers.keySet()) {
                requestBuilder.addHeader(headerName, (String)headers.get(headerName));
            }
            requestBuilder.url(oAuthRequest.getLocationUri());
            Response response = chain.proceed(requestBuilder.build());
            if ((response.code() == 401 || response.code() == 403) && updateTokenAndRetryOnAuthorizationFailure) {
                try {
                    if (this.updateAccessToken(requestAccessToken)) {
                        response.body().close();
                        return this.retryingIntercept(chain, false);
                    }
                }
                catch (Exception e) {
                    response.body().close();
                    throw e;
                }
            }
            return response;
        }
        return chain.proceed(chain.request());
    }

    public synchronized boolean updateAccessToken(String requestAccessToken) throws IOException {
        if (this.getAccessToken() == null || this.getAccessToken().equals(requestAccessToken)) {
            try {
                OAuthJSONAccessTokenResponse accessTokenResponse = this.oAuthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
                if (accessTokenResponse != null && accessTokenResponse.getAccessToken() != null) {
                    this.setAccessToken(accessTokenResponse.getAccessToken());
                    return !this.getAccessToken().equals(requestAccessToken);
                }
            }
            catch (OAuthProblemException | OAuthSystemException e) {
                throw new IOException(e);
            }
        }
        return false;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
    }

    private static class AuthInterceptor
    implements Interceptor {
        private final String clientId;
        private final String clientSecret;

        public AuthInterceptor(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        @NotNull
        public Response intercept(Interceptor.Chain chain) throws IOException {
            return chain.proceed(chain.request().newBuilder().addHeader("Authorization", Credentials.basic((String)this.clientId, (String)this.clientSecret)).build());
        }
    }
}

