/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.Batch;
import com.vertexvis.model.CreateBatchRequest;
import com.vertexvis.model.QueuedJob;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class BatchesApi {
    private ApiClient localVarApiClient;

    public BatchesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BatchesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createBatchCall(CreateBatchRequest createBatchRequest, ApiCallback _callback) throws ApiException {
        CreateBatchRequest localVarPostBody = createBatchRequest;
        String localVarPath = "/batches";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBatchValidateBeforeCall(CreateBatchRequest createBatchRequest, ApiCallback _callback) throws ApiException {
        if (createBatchRequest == null) {
            throw new ApiException("Missing the required parameter 'createBatchRequest' when calling createBatch(Async)");
        }
        Call localVarCall = this.createBatchCall(createBatchRequest, _callback);
        return localVarCall;
    }

    public QueuedJob createBatch(CreateBatchRequest createBatchRequest) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.createBatchWithHttpInfo(createBatchRequest);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> createBatchWithHttpInfo(CreateBatchRequest createBatchRequest) throws ApiException {
        Call localVarCall = this.createBatchValidateBeforeCall(createBatchRequest, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createBatchAsync(CreateBatchRequest createBatchRequest, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.createBatchValidateBeforeCall(createBatchRequest, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBatchCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/batches/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBatchValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getBatch(Async)");
        }
        Call localVarCall = this.getBatchCall(id, _callback);
        return localVarCall;
    }

    public Batch getBatch(UUID id) throws ApiException {
        ApiResponse<Batch> localVarResp = this.getBatchWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Batch> getBatchWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getBatchValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Batch>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBatchAsync(UUID id, ApiCallback<Batch> _callback) throws ApiException {
        Call localVarCall = this.getBatchValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Batch>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getQueuedBatchCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/queued-batches/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedBatchValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedBatch(Async)");
        }
        Call localVarCall = this.getQueuedBatchCall(id, _callback);
        return localVarCall;
    }

    public QueuedJob getQueuedBatch(UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedBatchWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedBatchWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getQueuedBatchValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedBatchAsync(UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedBatchValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

