/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import com.vertexvis.model.Link;
import com.vertexvis.model.SceneItemDataAttributes;
import com.vertexvis.model.SceneItemDataRelationships;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SceneItemData {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private SceneItemDataAttributes attributes;
    public static final String SERIALIZED_NAME_RELATIONSHIPS = "relationships";
    @SerializedName(value="relationships")
    private SceneItemDataRelationships relationships;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private Map<String, Link> links = null;

    public SceneItemData type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="scene-item", required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SceneItemData id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="f79d4760-0b71-44e4-ad0b-22743fdd4ca3", required=true, value="ID of the resource.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public SceneItemData attributes(SceneItemDataAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public SceneItemDataAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(SceneItemDataAttributes attributes) {
        this.attributes = attributes;
    }

    public SceneItemData relationships(SceneItemDataRelationships relationships) {
        this.relationships = relationships;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public SceneItemDataRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(SceneItemDataRelationships relationships) {
        this.relationships = relationships;
    }

    public SceneItemData links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public SceneItemData putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SceneItemData sceneItemData = (SceneItemData)o;
        return Objects.equals(this.type, sceneItemData.type) && Objects.equals(this.id, sceneItemData.id) && Objects.equals(this.attributes, sceneItemData.attributes) && Objects.equals(this.relationships, sceneItemData.relationships) && Objects.equals(this.links, sceneItemData.links);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, this.relationships, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SceneItemData {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

