/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples,   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.api;

import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.ProgressRequestBody;
import com.vertexvis.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.math.BigDecimal;
import com.vertexvis.model.Failure;
import java.io.File;
import com.vertexvis.model.PartRevision;
import com.vertexvis.model.PartRevisionList;
import com.vertexvis.model.QueuedJob;
import java.util.UUID;
import com.vertexvis.model.UpdatePartRevisionRequest;
import com.vertexvis.model.Vector3;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartRevisionsApi {
    private ApiClient localVarApiClient;

    public PartRevisionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PartRevisionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deletePartRevision
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  * content-location -  <br>  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deletePartRevisionCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/part-revisions/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deletePartRevisionValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deletePartRevision(Async)");
        }
        

        okhttp3.Call localVarCall = deletePartRevisionCall(id, _callback);
        return localVarCall;

    }

    /**
     * 
     * Delete a &#x60;part-revision&#x60;.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @return QueuedJob
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  * content-location -  <br>  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public QueuedJob deletePartRevision(UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = deletePartRevisionWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * 
     * Delete a &#x60;part-revision&#x60;.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @return ApiResponse&lt;QueuedJob&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  * content-location -  <br>  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<QueuedJob> deletePartRevisionWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = deletePartRevisionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Delete a &#x60;part-revision&#x60;.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  * content-location -  <br>  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deletePartRevisionAsync(UUID id, final ApiCallback<QueuedJob> _callback) throws ApiException {

        okhttp3.Call localVarCall = deletePartRevisionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getPartRevision
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param fieldsPartRevision Comma-separated list of fields to return in response. An empty value returns no fields. Due to its potential size, metadata is only returned if explicitly requested. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPartRevisionCall(UUID id, String fieldsPartRevision, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/part-revisions/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fieldsPartRevision != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("fields[part-revision]", fieldsPartRevision));
        }

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPartRevisionValidateBeforeCall(UUID id, String fieldsPartRevision, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getPartRevision(Async)");
        }
        

        okhttp3.Call localVarCall = getPartRevisionCall(id, fieldsPartRevision, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get a &#x60;part-revision&#x60; by ID.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param fieldsPartRevision Comma-separated list of fields to return in response. An empty value returns no fields. Due to its potential size, metadata is only returned if explicitly requested. (optional)
     * @return PartRevision
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public PartRevision getPartRevision(UUID id, String fieldsPartRevision) throws ApiException {
        ApiResponse<PartRevision> localVarResp = getPartRevisionWithHttpInfo(id, fieldsPartRevision);
        return localVarResp.getData();
    }

    /**
     * 
     * Get a &#x60;part-revision&#x60; by ID.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param fieldsPartRevision Comma-separated list of fields to return in response. An empty value returns no fields. Due to its potential size, metadata is only returned if explicitly requested. (optional)
     * @return ApiResponse&lt;PartRevision&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PartRevision> getPartRevisionWithHttpInfo(UUID id, String fieldsPartRevision) throws ApiException {
        okhttp3.Call localVarCall = getPartRevisionValidateBeforeCall(id, fieldsPartRevision, null);
        Type localVarReturnType = new TypeToken<PartRevision>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get a &#x60;part-revision&#x60; by ID.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param fieldsPartRevision Comma-separated list of fields to return in response. An empty value returns no fields. Due to its potential size, metadata is only returned if explicitly requested. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPartRevisionAsync(UUID id, String fieldsPartRevision, final ApiCallback<PartRevision> _callback) throws ApiException {

        okhttp3.Call localVarCall = getPartRevisionValidateBeforeCall(id, fieldsPartRevision, _callback);
        Type localVarReturnType = new TypeToken<PartRevision>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getPartRevisions
     * @param id The &#x60;part&#x60; ID. (required)
     * @param pageCursor The cursor for the next page of items. (optional)
     * @param pageSize The number of items to return. (optional)
     * @param filterSuppliedId Comma-separated list of supplied IDs to filter on. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPartRevisionsCall(UUID id, String pageCursor, Integer pageSize, String filterSuppliedId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/parts/{id}/part-revisions"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (pageCursor != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }

        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page[size]", pageSize));
        }

        if (filterSuppliedId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter[suppliedId]", filterSuppliedId));
        }

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPartRevisionsValidateBeforeCall(UUID id, String pageCursor, Integer pageSize, String filterSuppliedId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getPartRevisions(Async)");
        }
        

        okhttp3.Call localVarCall = getPartRevisionsCall(id, pageCursor, pageSize, filterSuppliedId, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get &#x60;part-revisions&#x60; for a &#x60;part&#x60;.
     * @param id The &#x60;part&#x60; ID. (required)
     * @param pageCursor The cursor for the next page of items. (optional)
     * @param pageSize The number of items to return. (optional)
     * @param filterSuppliedId Comma-separated list of supplied IDs to filter on. (optional)
     * @return PartRevisionList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public PartRevisionList getPartRevisions(UUID id, String pageCursor, Integer pageSize, String filterSuppliedId) throws ApiException {
        ApiResponse<PartRevisionList> localVarResp = getPartRevisionsWithHttpInfo(id, pageCursor, pageSize, filterSuppliedId);
        return localVarResp.getData();
    }

    /**
     * 
     * Get &#x60;part-revisions&#x60; for a &#x60;part&#x60;.
     * @param id The &#x60;part&#x60; ID. (required)
     * @param pageCursor The cursor for the next page of items. (optional)
     * @param pageSize The number of items to return. (optional)
     * @param filterSuppliedId Comma-separated list of supplied IDs to filter on. (optional)
     * @return ApiResponse&lt;PartRevisionList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PartRevisionList> getPartRevisionsWithHttpInfo(UUID id, String pageCursor, Integer pageSize, String filterSuppliedId) throws ApiException {
        okhttp3.Call localVarCall = getPartRevisionsValidateBeforeCall(id, pageCursor, pageSize, filterSuppliedId, null);
        Type localVarReturnType = new TypeToken<PartRevisionList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get &#x60;part-revisions&#x60; for a &#x60;part&#x60;.
     * @param id The &#x60;part&#x60; ID. (required)
     * @param pageCursor The cursor for the next page of items. (optional)
     * @param pageSize The number of items to return. (optional)
     * @param filterSuppliedId Comma-separated list of supplied IDs to filter on. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPartRevisionsAsync(UUID id, String pageCursor, Integer pageSize, String filterSuppliedId, final ApiCallback<PartRevisionList> _callback) throws ApiException {

        okhttp3.Call localVarCall = getPartRevisionsValidateBeforeCall(id, pageCursor, pageSize, filterSuppliedId, _callback);
        Type localVarReturnType = new TypeToken<PartRevisionList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getQueuedPartRevisionDeletion
     * @param id The &#x60;queued-part-revision-deletion&#x60; ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getQueuedPartRevisionDeletionCall(UUID id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/queued-part-revision-deletions/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getQueuedPartRevisionDeletionValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedPartRevisionDeletion(Async)");
        }
        

        okhttp3.Call localVarCall = getQueuedPartRevisionDeletionCall(id, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get a &#x60;queued-part-revision-deletion&#x60; by ID.
     * @param id The &#x60;queued-part-revision-deletion&#x60; ID. (required)
     * @return QueuedJob
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public QueuedJob getQueuedPartRevisionDeletion(UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = getQueuedPartRevisionDeletionWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * 
     * Get a &#x60;queued-part-revision-deletion&#x60; by ID.
     * @param id The &#x60;queued-part-revision-deletion&#x60; ID. (required)
     * @return ApiResponse&lt;QueuedJob&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<QueuedJob> getQueuedPartRevisionDeletionWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = getQueuedPartRevisionDeletionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get a &#x60;queued-part-revision-deletion&#x60; by ID.
     * @param id The &#x60;queued-part-revision-deletion&#x60; ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getQueuedPartRevisionDeletionAsync(UUID id, final ApiCallback<QueuedJob> _callback) throws ApiException {

        okhttp3.Call localVarCall = getQueuedPartRevisionDeletionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for renderPartRevision
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param height The height of the image to render. (optional)
     * @param width The width of the image to render. (optional)
     * @param cameraPosition The &#x60;camera&#x60; position vector. (optional)
     * @param cameraUp The &#x60;camera&#x60; up vector. (optional)
     * @param cameraLookAt The &#x60;camera&#x60; lookAt vector. (optional)
     * @param cameraPerspectivePosition The perspective camera position. (optional)
     * @param cameraPerspectiveLookAt The perspective camera look at position. (optional)
     * @param cameraPerspectiveUp The perspective camera up vector. (optional)
     * @param cameraOrthographicViewVector The orthographic camera view vector. (optional)
     * @param cameraOrthographicLookAt The orthographic camera look at position. (optional)
     * @param cameraOrthographicUp The orthographic camera up vector. (optional)
     * @param cameraOrthographicFovHeight The orthographic field-of-view height. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
        <tr><td> 504 </td><td> GatewayTimeout </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call renderPartRevisionCall(UUID id, Integer height, Integer width, Vector3 cameraPosition, Vector3 cameraUp, Vector3 cameraLookAt, Vector3 cameraPerspectivePosition, Vector3 cameraPerspectiveLookAt, Vector3 cameraPerspectiveUp, Vector3 cameraOrthographicViewVector, Vector3 cameraOrthographicLookAt, Vector3 cameraOrthographicUp, BigDecimal cameraOrthographicFovHeight, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/part-revisions/{id}/image"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (height != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("height", height));
        }

        if (width != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("width", width));
        }

        if (cameraPosition != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[position]", cameraPosition));
        }

        if (cameraUp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[up]", cameraUp));
        }

        if (cameraLookAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[lookAt]", cameraLookAt));
        }

        if (cameraPerspectivePosition != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[perspective][position]", cameraPerspectivePosition));
        }

        if (cameraPerspectiveLookAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[perspective][lookAt]", cameraPerspectiveLookAt));
        }

        if (cameraPerspectiveUp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[perspective][up]", cameraPerspectiveUp));
        }

        if (cameraOrthographicViewVector != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[orthographic][viewVector]", cameraOrthographicViewVector));
        }

        if (cameraOrthographicLookAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[orthographic][lookAt]", cameraOrthographicLookAt));
        }

        if (cameraOrthographicUp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[orthographic][up]", cameraOrthographicUp));
        }

        if (cameraOrthographicFovHeight != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("camera[orthographic][fovHeight]", cameraOrthographicFovHeight));
        }

        final String[] localVarAccepts = {
            "image/jpeg", "image/png", "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call renderPartRevisionValidateBeforeCall(UUID id, Integer height, Integer width, Vector3 cameraPosition, Vector3 cameraUp, Vector3 cameraLookAt, Vector3 cameraPerspectivePosition, Vector3 cameraPerspectiveLookAt, Vector3 cameraPerspectiveUp, Vector3 cameraOrthographicViewVector, Vector3 cameraOrthographicLookAt, Vector3 cameraOrthographicUp, BigDecimal cameraOrthographicFovHeight, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling renderPartRevision(Async)");
        }
        

        okhttp3.Call localVarCall = renderPartRevisionCall(id, height, width, cameraPosition, cameraUp, cameraLookAt, cameraPerspectivePosition, cameraPerspectiveLookAt, cameraPerspectiveUp, cameraOrthographicViewVector, cameraOrthographicLookAt, cameraOrthographicUp, cameraOrthographicFovHeight, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get a rendered image of a &#x60;part-revision&#x60;.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param height The height of the image to render. (optional)
     * @param width The width of the image to render. (optional)
     * @param cameraPosition The &#x60;camera&#x60; position vector. (optional)
     * @param cameraUp The &#x60;camera&#x60; up vector. (optional)
     * @param cameraLookAt The &#x60;camera&#x60; lookAt vector. (optional)
     * @param cameraPerspectivePosition The perspective camera position. (optional)
     * @param cameraPerspectiveLookAt The perspective camera look at position. (optional)
     * @param cameraPerspectiveUp The perspective camera up vector. (optional)
     * @param cameraOrthographicViewVector The orthographic camera view vector. (optional)
     * @param cameraOrthographicLookAt The orthographic camera look at position. (optional)
     * @param cameraOrthographicUp The orthographic camera up vector. (optional)
     * @param cameraOrthographicFovHeight The orthographic field-of-view height. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
        <tr><td> 504 </td><td> GatewayTimeout </td><td>  -  </td></tr>
     </table>
     */
    public File renderPartRevision(UUID id, Integer height, Integer width, Vector3 cameraPosition, Vector3 cameraUp, Vector3 cameraLookAt, Vector3 cameraPerspectivePosition, Vector3 cameraPerspectiveLookAt, Vector3 cameraPerspectiveUp, Vector3 cameraOrthographicViewVector, Vector3 cameraOrthographicLookAt, Vector3 cameraOrthographicUp, BigDecimal cameraOrthographicFovHeight) throws ApiException {
        ApiResponse<File> localVarResp = renderPartRevisionWithHttpInfo(id, height, width, cameraPosition, cameraUp, cameraLookAt, cameraPerspectivePosition, cameraPerspectiveLookAt, cameraPerspectiveUp, cameraOrthographicViewVector, cameraOrthographicLookAt, cameraOrthographicUp, cameraOrthographicFovHeight);
        return localVarResp.getData();
    }

    /**
     * 
     * Get a rendered image of a &#x60;part-revision&#x60;.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param height The height of the image to render. (optional)
     * @param width The width of the image to render. (optional)
     * @param cameraPosition The &#x60;camera&#x60; position vector. (optional)
     * @param cameraUp The &#x60;camera&#x60; up vector. (optional)
     * @param cameraLookAt The &#x60;camera&#x60; lookAt vector. (optional)
     * @param cameraPerspectivePosition The perspective camera position. (optional)
     * @param cameraPerspectiveLookAt The perspective camera look at position. (optional)
     * @param cameraPerspectiveUp The perspective camera up vector. (optional)
     * @param cameraOrthographicViewVector The orthographic camera view vector. (optional)
     * @param cameraOrthographicLookAt The orthographic camera look at position. (optional)
     * @param cameraOrthographicUp The orthographic camera up vector. (optional)
     * @param cameraOrthographicFovHeight The orthographic field-of-view height. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
        <tr><td> 504 </td><td> GatewayTimeout </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> renderPartRevisionWithHttpInfo(UUID id, Integer height, Integer width, Vector3 cameraPosition, Vector3 cameraUp, Vector3 cameraLookAt, Vector3 cameraPerspectivePosition, Vector3 cameraPerspectiveLookAt, Vector3 cameraPerspectiveUp, Vector3 cameraOrthographicViewVector, Vector3 cameraOrthographicLookAt, Vector3 cameraOrthographicUp, BigDecimal cameraOrthographicFovHeight) throws ApiException {
        okhttp3.Call localVarCall = renderPartRevisionValidateBeforeCall(id, height, width, cameraPosition, cameraUp, cameraLookAt, cameraPerspectivePosition, cameraPerspectiveLookAt, cameraPerspectiveUp, cameraOrthographicViewVector, cameraOrthographicLookAt, cameraOrthographicUp, cameraOrthographicFovHeight, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get a rendered image of a &#x60;part-revision&#x60;.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param height The height of the image to render. (optional)
     * @param width The width of the image to render. (optional)
     * @param cameraPosition The &#x60;camera&#x60; position vector. (optional)
     * @param cameraUp The &#x60;camera&#x60; up vector. (optional)
     * @param cameraLookAt The &#x60;camera&#x60; lookAt vector. (optional)
     * @param cameraPerspectivePosition The perspective camera position. (optional)
     * @param cameraPerspectiveLookAt The perspective camera look at position. (optional)
     * @param cameraPerspectiveUp The perspective camera up vector. (optional)
     * @param cameraOrthographicViewVector The orthographic camera view vector. (optional)
     * @param cameraOrthographicLookAt The orthographic camera look at position. (optional)
     * @param cameraOrthographicUp The orthographic camera up vector. (optional)
     * @param cameraOrthographicFovHeight The orthographic field-of-view height. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
        <tr><td> 504 </td><td> GatewayTimeout </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call renderPartRevisionAsync(UUID id, Integer height, Integer width, Vector3 cameraPosition, Vector3 cameraUp, Vector3 cameraLookAt, Vector3 cameraPerspectivePosition, Vector3 cameraPerspectiveLookAt, Vector3 cameraPerspectiveUp, Vector3 cameraOrthographicViewVector, Vector3 cameraOrthographicLookAt, Vector3 cameraOrthographicUp, BigDecimal cameraOrthographicFovHeight, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = renderPartRevisionValidateBeforeCall(id, height, width, cameraPosition, cameraUp, cameraLookAt, cameraPerspectivePosition, cameraPerspectiveLookAt, cameraPerspectiveUp, cameraOrthographicViewVector, cameraOrthographicLookAt, cameraOrthographicUp, cameraOrthographicFovHeight, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updatePartRevision
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param updatePartRevisionRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updatePartRevisionCall(UUID id, UpdatePartRevisionRequest updatePartRevisionRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = updatePartRevisionRequest;

        // create path and map variables
        String localVarPath = "/part-revisions/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/vnd.api+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updatePartRevisionValidateBeforeCall(UUID id, UpdatePartRevisionRequest updatePartRevisionRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updatePartRevision(Async)");
        }
        
        // verify the required parameter 'updatePartRevisionRequest' is set
        if (updatePartRevisionRequest == null) {
            throw new ApiException("Missing the required parameter 'updatePartRevisionRequest' when calling updatePartRevision(Async)");
        }
        

        okhttp3.Call localVarCall = updatePartRevisionCall(id, updatePartRevisionRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Update a &#x60;part-revision&#x60;. Note that metadata updates are eventually consistent.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param updatePartRevisionRequest  (required)
     * @return PartRevision
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public PartRevision updatePartRevision(UUID id, UpdatePartRevisionRequest updatePartRevisionRequest) throws ApiException {
        ApiResponse<PartRevision> localVarResp = updatePartRevisionWithHttpInfo(id, updatePartRevisionRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * Update a &#x60;part-revision&#x60;. Note that metadata updates are eventually consistent.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param updatePartRevisionRequest  (required)
     * @return ApiResponse&lt;PartRevision&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PartRevision> updatePartRevisionWithHttpInfo(UUID id, UpdatePartRevisionRequest updatePartRevisionRequest) throws ApiException {
        okhttp3.Call localVarCall = updatePartRevisionValidateBeforeCall(id, updatePartRevisionRequest, null);
        Type localVarReturnType = new TypeToken<PartRevision>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Update a &#x60;part-revision&#x60;. Note that metadata updates are eventually consistent.
     * @param id The &#x60;part-revision&#x60; ID. (required)
     * @param updatePartRevisionRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updatePartRevisionAsync(UUID id, UpdatePartRevisionRequest updatePartRevisionRequest, final ApiCallback<PartRevision> _callback) throws ApiException {

        okhttp3.Call localVarCall = updatePartRevisionValidateBeforeCall(id, updatePartRevisionRequest, _callback);
        Type localVarReturnType = new TypeToken<PartRevision>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
