/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.Application;
import com.vertexvis.model.ApplicationList;
import com.vertexvis.model.CreateApplicationRequest;
import com.vertexvis.model.CreatedApplication;
import com.vertexvis.model.UpdateApplicationRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class ApplicationsApi {
    private ApiClient localVarApiClient;

    public ApplicationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createApplicationCall(CreateApplicationRequest createApplicationRequest, ApiCallback _callback) throws ApiException {
        CreateApplicationRequest localVarPostBody = createApplicationRequest;
        String localVarPath = "/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createApplicationValidateBeforeCall(CreateApplicationRequest createApplicationRequest, ApiCallback _callback) throws ApiException {
        if (createApplicationRequest == null) {
            throw new ApiException("Missing the required parameter 'createApplicationRequest' when calling createApplication(Async)");
        }
        Call localVarCall = this.createApplicationCall(createApplicationRequest, _callback);
        return localVarCall;
    }

    public CreatedApplication createApplication(CreateApplicationRequest createApplicationRequest) throws ApiException {
        ApiResponse<CreatedApplication> localVarResp = this.createApplicationWithHttpInfo(createApplicationRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreatedApplication> createApplicationWithHttpInfo(CreateApplicationRequest createApplicationRequest) throws ApiException {
        Call localVarCall = this.createApplicationValidateBeforeCall(createApplicationRequest, null);
        Type localVarReturnType = new TypeToken<CreatedApplication>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createApplicationAsync(CreateApplicationRequest createApplicationRequest, ApiCallback<CreatedApplication> _callback) throws ApiException {
        Call localVarCall = this.createApplicationValidateBeforeCall(createApplicationRequest, _callback);
        Type localVarReturnType = new TypeToken<CreatedApplication>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteApplicationCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteApplicationValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteApplication(Async)");
        }
        Call localVarCall = this.deleteApplicationCall(id, _callback);
        return localVarCall;
    }

    public void deleteApplication(UUID id) throws ApiException {
        this.deleteApplicationWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteApplicationWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.deleteApplicationValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteApplicationAsync(UUID id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteApplicationValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getApplicationCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getApplicationValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getApplication(Async)");
        }
        Call localVarCall = this.getApplicationCall(id, _callback);
        return localVarCall;
    }

    public Application getApplication(UUID id) throws ApiException {
        ApiResponse<Application> localVarResp = this.getApplicationWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Application> getApplicationWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getApplicationValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getApplicationAsync(UUID id, ApiCallback<Application> _callback) throws ApiException {
        Call localVarCall = this.getApplicationValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getApplicationsCall(String pageCursor, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getApplicationsValidateBeforeCall(String pageCursor, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getApplicationsCall(pageCursor, pageSize, _callback);
        return localVarCall;
    }

    public ApplicationList getApplications(String pageCursor, Integer pageSize) throws ApiException {
        ApiResponse<ApplicationList> localVarResp = this.getApplicationsWithHttpInfo(pageCursor, pageSize);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationList> getApplicationsWithHttpInfo(String pageCursor, Integer pageSize) throws ApiException {
        Call localVarCall = this.getApplicationsValidateBeforeCall(pageCursor, pageSize, null);
        Type localVarReturnType = new TypeToken<ApplicationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getApplicationsAsync(String pageCursor, Integer pageSize, ApiCallback<ApplicationList> _callback) throws ApiException {
        Call localVarCall = this.getApplicationsValidateBeforeCall(pageCursor, pageSize, _callback);
        Type localVarReturnType = new TypeToken<ApplicationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateApplicationCall(UUID id, UpdateApplicationRequest updateApplicationRequest, ApiCallback _callback) throws ApiException {
        UpdateApplicationRequest localVarPostBody = updateApplicationRequest;
        String localVarPath = "/applications/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateApplicationValidateBeforeCall(UUID id, UpdateApplicationRequest updateApplicationRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateApplication(Async)");
        }
        if (updateApplicationRequest == null) {
            throw new ApiException("Missing the required parameter 'updateApplicationRequest' when calling updateApplication(Async)");
        }
        Call localVarCall = this.updateApplicationCall(id, updateApplicationRequest, _callback);
        return localVarCall;
    }

    public Application updateApplication(UUID id, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
        ApiResponse<Application> localVarResp = this.updateApplicationWithHttpInfo(id, updateApplicationRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Application> updateApplicationWithHttpInfo(UUID id, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
        Call localVarCall = this.updateApplicationValidateBeforeCall(id, updateApplicationRequest, null);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateApplicationAsync(UUID id, UpdateApplicationRequest updateApplicationRequest, ApiCallback<Application> _callback) throws ApiException {
        Call localVarCall = this.updateApplicationValidateBeforeCall(id, updateApplicationRequest, _callback);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

