/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import com.vertexvis.model.Vector3;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="A camera type where an object's size stays consistent regardless of its distance to the camera.")
public class OrthographicCamera {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_VIEW_VECTOR = "viewVector";
    @SerializedName(value="viewVector")
    private Vector3 viewVector;
    public static final String SERIALIZED_NAME_LOOK_AT = "lookAt";
    @SerializedName(value="lookAt")
    private Vector3 lookAt;
    public static final String SERIALIZED_NAME_UP = "up";
    @SerializedName(value="up")
    private Vector3 up;
    public static final String SERIALIZED_NAME_FOV_HEIGHT = "fovHeight";
    @SerializedName(value="fovHeight")
    private BigDecimal fovHeight;

    public OrthographicCamera type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="orthographic", value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public OrthographicCamera viewVector(Vector3 viewVector) {
        this.viewVector = viewVector;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Vector3 getViewVector() {
        return this.viewVector;
    }

    public void setViewVector(Vector3 viewVector) {
        this.viewVector = viewVector;
    }

    public OrthographicCamera lookAt(Vector3 lookAt) {
        this.lookAt = lookAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Vector3 getLookAt() {
        return this.lookAt;
    }

    public void setLookAt(Vector3 lookAt) {
        this.lookAt = lookAt;
    }

    public OrthographicCamera up(Vector3 up) {
        this.up = up;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Vector3 getUp() {
        return this.up;
    }

    public void setUp(Vector3 up) {
        this.up = up;
    }

    public OrthographicCamera fovHeight(BigDecimal fovHeight) {
        this.fovHeight = fovHeight;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public BigDecimal getFovHeight() {
        return this.fovHeight;
    }

    public void setFovHeight(BigDecimal fovHeight) {
        this.fovHeight = fovHeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrthographicCamera orthographicCamera = (OrthographicCamera)o;
        return Objects.equals(this.type, orthographicCamera.type) && Objects.equals(this.viewVector, orthographicCamera.viewVector) && Objects.equals(this.lookAt, orthographicCamera.lookAt) && Objects.equals(this.up, orthographicCamera.up) && Objects.equals(this.fovHeight, orthographicCamera.fovHeight);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.viewVector, this.lookAt, this.up, this.fovHeight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrthographicCamera {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    viewVector: ").append(this.toIndentedString(this.viewVector)).append("\n");
        sb.append("    lookAt: ").append(this.toIndentedString(this.lookAt)).append("\n");
        sb.append("    up: ").append(this.toIndentedString(this.up)).append("\n");
        sb.append("    fovHeight: ").append(this.toIndentedString(this.fovHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

