/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreateExportRequest;
import com.vertexvis.model.Export;
import com.vertexvis.model.QueuedJob;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class ExportsApi {
    private ApiClient localVarApiClient;

    public ExportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExportsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createExportCall(CreateExportRequest createExportRequest, ApiCallback _callback) throws ApiException {
        CreateExportRequest localVarPostBody = createExportRequest;
        String localVarPath = "/exports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createExportValidateBeforeCall(CreateExportRequest createExportRequest, ApiCallback _callback) throws ApiException {
        if (createExportRequest == null) {
            throw new ApiException("Missing the required parameter 'createExportRequest' when calling createExport(Async)");
        }
        Call localVarCall = this.createExportCall(createExportRequest, _callback);
        return localVarCall;
    }

    public QueuedJob createExport(CreateExportRequest createExportRequest) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.createExportWithHttpInfo(createExportRequest);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> createExportWithHttpInfo(CreateExportRequest createExportRequest) throws ApiException {
        Call localVarCall = this.createExportValidateBeforeCall(createExportRequest, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createExportAsync(CreateExportRequest createExportRequest, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.createExportValidateBeforeCall(createExportRequest, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExportCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/exports/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExportValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getExport(Async)");
        }
        Call localVarCall = this.getExportCall(id, _callback);
        return localVarCall;
    }

    public Export getExport(UUID id) throws ApiException {
        ApiResponse<Export> localVarResp = this.getExportWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Export> getExportWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getExportValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExportAsync(UUID id, ApiCallback<Export> _callback) throws ApiException {
        Call localVarCall = this.getExportValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getQueuedExportCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/queued-exports/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedExportValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedExport(Async)");
        }
        Call localVarCall = this.getQueuedExportCall(id, _callback);
        return localVarCall;
    }

    public QueuedJob getQueuedExport(UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedExportWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedExportWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getQueuedExportValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedExportAsync(UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedExportValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

