/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.CreatePartRequest;
import com.vertexvis.model.Part;
import com.vertexvis.model.PartList;
import com.vertexvis.model.QueuedJob;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class PartsApi {
    private ApiClient localVarApiClient;

    public PartsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PartsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createPartCall(CreatePartRequest createPartRequest, ApiCallback _callback) throws ApiException {
        CreatePartRequest localVarPostBody = createPartRequest;
        String localVarPath = "/parts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPartValidateBeforeCall(CreatePartRequest createPartRequest, ApiCallback _callback) throws ApiException {
        if (createPartRequest == null) {
            throw new ApiException("Missing the required parameter 'createPartRequest' when calling createPart(Async)");
        }
        Call localVarCall = this.createPartCall(createPartRequest, _callback);
        return localVarCall;
    }

    public Part createPart(CreatePartRequest createPartRequest) throws ApiException {
        ApiResponse<Part> localVarResp = this.createPartWithHttpInfo(createPartRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Part> createPartWithHttpInfo(CreatePartRequest createPartRequest) throws ApiException {
        Call localVarCall = this.createPartValidateBeforeCall(createPartRequest, null);
        Type localVarReturnType = new TypeToken<Part>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createPartAsync(CreatePartRequest createPartRequest, ApiCallback<Part> _callback) throws ApiException {
        Call localVarCall = this.createPartValidateBeforeCall(createPartRequest, _callback);
        Type localVarReturnType = new TypeToken<Part>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deletePartCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/parts/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePartValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deletePart(Async)");
        }
        Call localVarCall = this.deletePartCall(id, _callback);
        return localVarCall;
    }

    public QueuedJob deletePart(UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.deletePartWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> deletePartWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.deletePartValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deletePartAsync(UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.deletePartValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPartCall(UUID id, String include, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/parts/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (include != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include", include));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPartValidateBeforeCall(UUID id, String include, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getPart(Async)");
        }
        Call localVarCall = this.getPartCall(id, include, _callback);
        return localVarCall;
    }

    public Part getPart(UUID id, String include) throws ApiException {
        ApiResponse<Part> localVarResp = this.getPartWithHttpInfo(id, include);
        return localVarResp.getData();
    }

    public ApiResponse<Part> getPartWithHttpInfo(UUID id, String include) throws ApiException {
        Call localVarCall = this.getPartValidateBeforeCall(id, include, null);
        Type localVarReturnType = new TypeToken<Part>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPartAsync(UUID id, String include, ApiCallback<Part> _callback) throws ApiException {
        Call localVarCall = this.getPartValidateBeforeCall(id, include, _callback);
        Type localVarReturnType = new TypeToken<Part>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPartsCall(String pageCursor, Integer pageSize, String filterSuppliedId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/parts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if (filterSuppliedId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[suppliedId]", filterSuppliedId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPartsValidateBeforeCall(String pageCursor, Integer pageSize, String filterSuppliedId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getPartsCall(pageCursor, pageSize, filterSuppliedId, _callback);
        return localVarCall;
    }

    public PartList getParts(String pageCursor, Integer pageSize, String filterSuppliedId) throws ApiException {
        ApiResponse<PartList> localVarResp = this.getPartsWithHttpInfo(pageCursor, pageSize, filterSuppliedId);
        return localVarResp.getData();
    }

    public ApiResponse<PartList> getPartsWithHttpInfo(String pageCursor, Integer pageSize, String filterSuppliedId) throws ApiException {
        Call localVarCall = this.getPartsValidateBeforeCall(pageCursor, pageSize, filterSuppliedId, null);
        Type localVarReturnType = new TypeToken<PartList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPartsAsync(String pageCursor, Integer pageSize, String filterSuppliedId, ApiCallback<PartList> _callback) throws ApiException {
        Call localVarCall = this.getPartsValidateBeforeCall(pageCursor, pageSize, filterSuppliedId, _callback);
        Type localVarReturnType = new TypeToken<PartList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getQueuedPartDeletionCall(UUID id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/queued-part-deletions/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueuedPartDeletionValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getQueuedPartDeletion(Async)");
        }
        Call localVarCall = this.getQueuedPartDeletionCall(id, _callback);
        return localVarCall;
    }

    public QueuedJob getQueuedPartDeletion(UUID id) throws ApiException {
        ApiResponse<QueuedJob> localVarResp = this.getQueuedPartDeletionWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<QueuedJob> getQueuedPartDeletionWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getQueuedPartDeletionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueuedPartDeletionAsync(UUID id, ApiCallback<QueuedJob> _callback) throws ApiException {
        Call localVarCall = this.getQueuedPartDeletionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<QueuedJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

