/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import com.vertexvis.model.ApiErrorSource;
import com.vertexvis.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ApiError {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private Map<String, Link> links = null;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private String code;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DETAIL = "detail";
    @SerializedName(value="detail")
    private String detail;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private ApiErrorSource source;
    public static final String SERIALIZED_NAME_META = "meta";
    @SerializedName(value="meta")
    private Map<String, String> meta = null;

    public ApiError id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7c46d4c3-e065-4eae-87ec-08233cf8743b", value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ApiError links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ApiError putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ApiError status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="400", value="")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ApiError code(String code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ValidationError", value="")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ApiError title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A validation error occurred.", value="")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ApiError detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="$.data.attributes.suppliedId: is missing but it is required", value="")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public ApiError source(ApiErrorSource source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ApiErrorSource getSource() {
        return this.source;
    }

    public void setSource(ApiErrorSource source) {
        this.source = source;
    }

    public ApiError meta(Map<String, String> meta) {
        this.meta = meta;
        return this;
    }

    public ApiError putMetaItem(String key, String metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, String>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiError apiError = (ApiError)o;
        return Objects.equals(this.id, apiError.id) && Objects.equals(this.links, apiError.links) && Objects.equals(this.status, apiError.status) && Objects.equals(this.code, apiError.code) && Objects.equals(this.title, apiError.title) && Objects.equals(this.detail, apiError.detail) && Objects.equals(this.source, apiError.source) && Objects.equals(this.meta, apiError.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.links, this.status, this.code, this.title, this.detail, this.source, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiError {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

