/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import com.vertexvis.model.Vector3;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="A camera type that mimics the way the human eye sees.")
public class PerspectiveCamera {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_POSITION = "position";
    @SerializedName(value="position")
    private Vector3 position;
    public static final String SERIALIZED_NAME_LOOK_AT = "lookAt";
    @SerializedName(value="lookAt")
    private Vector3 lookAt;
    public static final String SERIALIZED_NAME_UP = "up";
    @SerializedName(value="up")
    private Vector3 up;

    public PerspectiveCamera type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="perspective", value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PerspectiveCamera position(Vector3 position) {
        this.position = position;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Vector3 getPosition() {
        return this.position;
    }

    public void setPosition(Vector3 position) {
        this.position = position;
    }

    public PerspectiveCamera lookAt(Vector3 lookAt) {
        this.lookAt = lookAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Vector3 getLookAt() {
        return this.lookAt;
    }

    public void setLookAt(Vector3 lookAt) {
        this.lookAt = lookAt;
    }

    public PerspectiveCamera up(Vector3 up) {
        this.up = up;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Vector3 getUp() {
        return this.up;
    }

    public void setUp(Vector3 up) {
        this.up = up;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerspectiveCamera perspectiveCamera = (PerspectiveCamera)o;
        return Objects.equals(this.type, perspectiveCamera.type) && Objects.equals(this.position, perspectiveCamera.position) && Objects.equals(this.lookAt, perspectiveCamera.lookAt) && Objects.equals(this.up, perspectiveCamera.up);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.position, this.lookAt, this.up);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerspectiveCamera {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    lookAt: ").append(this.toIndentedString(this.lookAt)).append("\n");
        sb.append("    up: ").append(this.toIndentedString(this.up)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

