/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples,   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.model.AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CreatePartRequestDataAttributes
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CreatePartRequestDataAttributes {
  public static final String SERIALIZED_NAME_SUPPLIED_ID = "suppliedId";
  @SerializedName(SERIALIZED_NAME_SUPPLIED_ID)
  private String suppliedId;

  public static final String SERIALIZED_NAME_SUPPLIED_REVISION_ID = "suppliedRevisionId";
  @SerializedName(SERIALIZED_NAME_SUPPLIED_REVISION_ID)
  private String suppliedRevisionId;

  public static final String SERIALIZED_NAME_INDEX_METADATA = "indexMetadata";
  @SerializedName(SERIALIZED_NAME_INDEX_METADATA)
  private Boolean indexMetadata;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private Map<String, AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType> metadata = null;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_SUPPLIED_ID_KEY = "suppliedIdKey";
  @SerializedName(SERIALIZED_NAME_SUPPLIED_ID_KEY)
  private String suppliedIdKey;

  public static final String SERIALIZED_NAME_SUPPLIED_REVISION_ID_KEY = "suppliedRevisionIdKey";
  @SerializedName(SERIALIZED_NAME_SUPPLIED_REVISION_ID_KEY)
  private String suppliedRevisionIdKey;

  public static final String SERIALIZED_NAME_SUPPLIED_INSTANCE_ID_KEY = "suppliedInstanceIdKey";
  @SerializedName(SERIALIZED_NAME_SUPPLIED_INSTANCE_ID_KEY)
  private String suppliedInstanceIdKey;

  public CreatePartRequestDataAttributes() { 
  }

  public CreatePartRequestDataAttributes suppliedId(String suppliedId) {
    
    this.suppliedId = suppliedId;
    return this;
  }

   /**
   * ID provided for correlation. For example, an existing ID from a PLM system. 
   * @return suppliedId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "PN12345", value = "ID provided for correlation. For example, an existing ID from a PLM system. ")

  public String getSuppliedId() {
    return suppliedId;
  }


  public void setSuppliedId(String suppliedId) {
    this.suppliedId = suppliedId;
  }


  public CreatePartRequestDataAttributes suppliedRevisionId(String suppliedRevisionId) {
    
    this.suppliedRevisionId = suppliedRevisionId;
    return this;
  }

   /**
   * ID provided for correlation. For example, an existing ID from a PLM system. Sending a new suppliedRevisionId combined with an existing suppliedId will create a new part revision for an existing part. 
   * @return suppliedRevisionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "RevA", value = "ID provided for correlation. For example, an existing ID from a PLM system. Sending a new suppliedRevisionId combined with an existing suppliedId will create a new part revision for an existing part. ")

  public String getSuppliedRevisionId() {
    return suppliedRevisionId;
  }


  public void setSuppliedRevisionId(String suppliedRevisionId) {
    this.suppliedRevisionId = suppliedRevisionId;
  }


  public CreatePartRequestDataAttributes indexMetadata(Boolean indexMetadata) {
    
    this.indexMetadata = indexMetadata;
    return this;
  }

   /**
   * Whether or not to index metadata in the part file. To ignore metadata from the part file and add your own, pass &#x60;false&#x60; for &#x60;indexMetadata&#x60; and supply custom metadata using the &#x60;metadata&#x60; field. 
   * @return indexMetadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Whether or not to index metadata in the part file. To ignore metadata from the part file and add your own, pass `false` for `indexMetadata` and supply custom metadata using the `metadata` field. ")

  public Boolean getIndexMetadata() {
    return indexMetadata;
  }


  public void setIndexMetadata(Boolean indexMetadata) {
    this.indexMetadata = indexMetadata;
  }


  public CreatePartRequestDataAttributes metadata(Map<String, AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public CreatePartRequestDataAttributes putMetadataItem(String key, AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Additional metadata about the &#x60;part&#x60; and/or &#x60;part-revision&#x60;. This metadata will take precedence over any metadata that belongs to the part file if &#x60;indexMetadata&#x60; is specified. 
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Additional metadata about the `part` and/or `part-revision`. This metadata will take precedence over any metadata that belongs to the part file if `indexMetadata` is specified. ")

  public Map<String, AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType> getMetadata() {
    return metadata;
  }


  public void setMetadata(Map<String, AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType> metadata) {
    this.metadata = metadata;
  }


  public CreatePartRequestDataAttributes name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name to be used for the root part.
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1/2in. Flat Washer", value = "Name to be used for the root part.")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public CreatePartRequestDataAttributes suppliedIdKey(String suppliedIdKey) {
    
    this.suppliedIdKey = suppliedIdKey;
    return this;
  }

   /**
   * Metadata key used to extract an ID used for correlation.
   * @return suppliedIdKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ProductNumber", value = "Metadata key used to extract an ID used for correlation.")

  public String getSuppliedIdKey() {
    return suppliedIdKey;
  }


  public void setSuppliedIdKey(String suppliedIdKey) {
    this.suppliedIdKey = suppliedIdKey;
  }


  public CreatePartRequestDataAttributes suppliedRevisionIdKey(String suppliedRevisionIdKey) {
    
    this.suppliedRevisionIdKey = suppliedRevisionIdKey;
    return this;
  }

   /**
   * Metadata key used to extract an ID used for correlation.
   * @return suppliedRevisionIdKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "RevisionId", value = "Metadata key used to extract an ID used for correlation.")

  public String getSuppliedRevisionIdKey() {
    return suppliedRevisionIdKey;
  }


  public void setSuppliedRevisionIdKey(String suppliedRevisionIdKey) {
    this.suppliedRevisionIdKey = suppliedRevisionIdKey;
  }


  public CreatePartRequestDataAttributes suppliedInstanceIdKey(String suppliedInstanceIdKey) {
    
    this.suppliedInstanceIdKey = suppliedInstanceIdKey;
    return this;
  }

   /**
   * Metadata key used to extract an ID used for correlation.
   * @return suppliedInstanceIdKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "InstanceId", value = "Metadata key used to extract an ID used for correlation.")

  public String getSuppliedInstanceIdKey() {
    return suppliedInstanceIdKey;
  }


  public void setSuppliedInstanceIdKey(String suppliedInstanceIdKey) {
    this.suppliedInstanceIdKey = suppliedInstanceIdKey;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatePartRequestDataAttributes createPartRequestDataAttributes = (CreatePartRequestDataAttributes) o;
    return Objects.equals(this.suppliedId, createPartRequestDataAttributes.suppliedId) &&
        Objects.equals(this.suppliedRevisionId, createPartRequestDataAttributes.suppliedRevisionId) &&
        Objects.equals(this.indexMetadata, createPartRequestDataAttributes.indexMetadata) &&
        Objects.equals(this.metadata, createPartRequestDataAttributes.metadata) &&
        Objects.equals(this.name, createPartRequestDataAttributes.name) &&
        Objects.equals(this.suppliedIdKey, createPartRequestDataAttributes.suppliedIdKey) &&
        Objects.equals(this.suppliedRevisionIdKey, createPartRequestDataAttributes.suppliedRevisionIdKey) &&
        Objects.equals(this.suppliedInstanceIdKey, createPartRequestDataAttributes.suppliedInstanceIdKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(suppliedId, suppliedRevisionId, indexMetadata, metadata, name, suppliedIdKey, suppliedRevisionIdKey, suppliedInstanceIdKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatePartRequestDataAttributes {\n");
    sb.append("    suppliedId: ").append(toIndentedString(suppliedId)).append("\n");
    sb.append("    suppliedRevisionId: ").append(toIndentedString(suppliedRevisionId)).append("\n");
    sb.append("    indexMetadata: ").append(toIndentedString(indexMetadata)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    suppliedIdKey: ").append(toIndentedString(suppliedIdKey)).append("\n");
    sb.append("    suppliedRevisionIdKey: ").append(toIndentedString(suppliedRevisionIdKey)).append("\n");
    sb.append("    suppliedInstanceIdKey: ").append(toIndentedString(suppliedInstanceIdKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

