/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples,   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.model.Orientation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * UpdateSceneRequestDataAttributes
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class UpdateSceneRequestDataAttributes {
  public static final String SERIALIZED_NAME_CAMERA = "camera";
  @SerializedName(SERIALIZED_NAME_CAMERA)
  private AnyOfPerspectiveCameraOrthographicCameraCameraFit camera;

  /**
   * State of the scene.
   */
  @JsonAdapter(StateEnum.Adapter.class)
  public enum StateEnum {
    DRAFT("draft"),
    
    COMMIT("commit");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StateEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StateEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StateEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StateEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATE = "state";
  @SerializedName(SERIALIZED_NAME_STATE)
  private StateEnum state;

  public static final String SERIALIZED_NAME_SUPPLIED_ID = "suppliedId";
  @SerializedName(SERIALIZED_NAME_SUPPLIED_ID)
  private String suppliedId;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_TREE_ENABLED = "treeEnabled";
  @SerializedName(SERIALIZED_NAME_TREE_ENABLED)
  private Boolean treeEnabled;

  public static final String SERIALIZED_NAME_WORLD_ORIENTATION = "worldOrientation";
  @SerializedName(SERIALIZED_NAME_WORLD_ORIENTATION)
  private Orientation worldOrientation;

  public UpdateSceneRequestDataAttributes() { 
  }

  public UpdateSceneRequestDataAttributes camera(AnyOfPerspectiveCameraOrthographicCameraCameraFit camera) {
    
    this.camera = camera;
    return this;
  }

   /**
   * Get camera
   * @return camera
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public AnyOfPerspectiveCameraOrthographicCameraCameraFit getCamera() {
    return camera;
  }


  public void setCamera(AnyOfPerspectiveCameraOrthographicCameraCameraFit camera) {
    this.camera = camera;
  }


  public UpdateSceneRequestDataAttributes state(StateEnum state) {
    
    this.state = state;
    return this;
  }

   /**
   * State of the scene.
   * @return state
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "commit", value = "State of the scene.")

  public StateEnum getState() {
    return state;
  }


  public void setState(StateEnum state) {
    this.state = state;
  }


  public UpdateSceneRequestDataAttributes suppliedId(String suppliedId) {
    
    this.suppliedId = suppliedId;
    return this;
  }

   /**
   * ID provided for correlation. For example, an existing ID from a PLM system.
   * @return suppliedId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "PN12345", value = "ID provided for correlation. For example, an existing ID from a PLM system.")

  public String getSuppliedId() {
    return suppliedId;
  }


  public void setSuppliedId(String suppliedId) {
    this.suppliedId = suppliedId;
  }


  public UpdateSceneRequestDataAttributes name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "some-string", value = "")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public UpdateSceneRequestDataAttributes treeEnabled(Boolean treeEnabled) {
    
    this.treeEnabled = treeEnabled;
    return this;
  }

   /**
   * Whether or not scene trees can be viewed for this scene.
   * @return treeEnabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether or not scene trees can be viewed for this scene.")

  public Boolean getTreeEnabled() {
    return treeEnabled;
  }


  public void setTreeEnabled(Boolean treeEnabled) {
    this.treeEnabled = treeEnabled;
  }


  public UpdateSceneRequestDataAttributes worldOrientation(Orientation worldOrientation) {
    
    this.worldOrientation = worldOrientation;
    return this;
  }

   /**
   * Get worldOrientation
   * @return worldOrientation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Orientation getWorldOrientation() {
    return worldOrientation;
  }


  public void setWorldOrientation(Orientation worldOrientation) {
    this.worldOrientation = worldOrientation;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateSceneRequestDataAttributes updateSceneRequestDataAttributes = (UpdateSceneRequestDataAttributes) o;
    return Objects.equals(this.camera, updateSceneRequestDataAttributes.camera) &&
        Objects.equals(this.state, updateSceneRequestDataAttributes.state) &&
        Objects.equals(this.suppliedId, updateSceneRequestDataAttributes.suppliedId) &&
        Objects.equals(this.name, updateSceneRequestDataAttributes.name) &&
        Objects.equals(this.treeEnabled, updateSceneRequestDataAttributes.treeEnabled) &&
        Objects.equals(this.worldOrientation, updateSceneRequestDataAttributes.worldOrientation);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(camera, state, suppliedId, name, treeEnabled, worldOrientation);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateSceneRequestDataAttributes {\n");
    sb.append("    camera: ").append(toIndentedString(camera)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    suppliedId: ").append(toIndentedString(suppliedId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    treeEnabled: ").append(toIndentedString(treeEnabled)).append("\n");
    sb.append("    worldOrientation: ").append(toIndentedString(worldOrientation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

