/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import com.vertexvis.model.Matrix4;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="A reference to an existing PartRevision. Specify one and only one of referenceId or suppliedReferenceId to refer to a revision.")
public class PartRevisionInstance {
    public static final String SERIALIZED_NAME_ORDINAL = "ordinal";
    @SerializedName(value="ordinal")
    private Integer ordinal;
    public static final String SERIALIZED_NAME_REVISION_ID = "revisionId";
    @SerializedName(value="revisionId")
    private UUID revisionId;
    public static final String SERIALIZED_NAME_SUPPLIED_REVISION_ID = "suppliedRevisionId";
    @SerializedName(value="suppliedRevisionId")
    private String suppliedRevisionId;
    public static final String SERIALIZED_NAME_TRANSFORM = "transform";
    @SerializedName(value="transform")
    private Matrix4 transform;

    public PartRevisionInstance ordinal(Integer ordinal) {
        this.ordinal = ordinal;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A 0-based index used for defining a consistent ordering for children of an assembly")
    public Integer getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public PartRevisionInstance revisionId(UUID revisionId) {
        this.revisionId = revisionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="f79d4760-0b71-44e4-ad0b-22743fdd4ca3", value="ID of the resource.")
    public UUID getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(UUID revisionId) {
        this.revisionId = revisionId;
    }

    public PartRevisionInstance suppliedRevisionId(String suppliedRevisionId) {
        this.suppliedRevisionId = suppliedRevisionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="some-string", value="")
    public String getSuppliedRevisionId() {
        return this.suppliedRevisionId;
    }

    public void setSuppliedRevisionId(String suppliedRevisionId) {
        this.suppliedRevisionId = suppliedRevisionId;
    }

    public PartRevisionInstance transform(Matrix4 transform) {
        this.transform = transform;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Matrix4 getTransform() {
        return this.transform;
    }

    public void setTransform(Matrix4 transform) {
        this.transform = transform;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartRevisionInstance partRevisionInstance = (PartRevisionInstance)o;
        return Objects.equals(this.ordinal, partRevisionInstance.ordinal) && Objects.equals(this.revisionId, partRevisionInstance.revisionId) && Objects.equals(this.suppliedRevisionId, partRevisionInstance.suppliedRevisionId) && Objects.equals(this.transform, partRevisionInstance.transform);
    }

    public int hashCode() {
        return Objects.hash(this.ordinal, this.revisionId, this.suppliedRevisionId, this.transform);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartRevisionInstance {\n");
        sb.append("    ordinal: ").append(this.toIndentedString(this.ordinal)).append("\n");
        sb.append("    revisionId: ").append(this.toIndentedString(this.revisionId)).append("\n");
        sb.append("    suppliedRevisionId: ").append(this.toIndentedString(this.suppliedRevisionId)).append("\n");
        sb.append("    transform: ").append(this.toIndentedString(this.transform)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

