/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples:   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.api;

import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.ProgressRequestBody;
import com.vertexvis.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.vertexvis.model.AdminConsentAcceptRequest;
import com.vertexvis.model.AdminLoginAcceptRequest;
import com.vertexvis.model.AdminRedirectTo;
import com.vertexvis.model.Failure;
import com.vertexvis.model.OAuth2BadRequest;
import com.vertexvis.model.OAuth2Token;
import com.vertexvis.model.RevokeOAuth2TokenRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Oauth2Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public Oauth2Api() {
        this(Configuration.getDefaultApiClient());
    }

    public Oauth2Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for adminAcceptConsent
     * @param challenge Challenge ID from oauth2 flow (required)
     * @param adminConsentAcceptRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminAcceptConsentCall(String challenge, AdminConsentAcceptRequest adminConsentAcceptRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = adminConsentAcceptRequest;

        // create path and map variables
        String localVarPath = "/oauth2/auth/requests/consent/accept";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (challenge != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("challenge", challenge));
        }

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/vnd.api+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2Internal" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminAcceptConsentValidateBeforeCall(String challenge, AdminConsentAcceptRequest adminConsentAcceptRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'challenge' is set
        if (challenge == null) {
            throw new ApiException("Missing the required parameter 'challenge' when calling adminAcceptConsent(Async)");
        }
        

        okhttp3.Call localVarCall = adminAcceptConsentCall(challenge, adminConsentAcceptRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Accept Consent Challenge to login.
     * @param challenge Challenge ID from oauth2 flow (required)
     * @param adminConsentAcceptRequest  (optional)
     * @return AdminRedirectTo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public AdminRedirectTo adminAcceptConsent(String challenge, AdminConsentAcceptRequest adminConsentAcceptRequest) throws ApiException {
        ApiResponse<AdminRedirectTo> localVarResp = adminAcceptConsentWithHttpInfo(challenge, adminConsentAcceptRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * Accept Consent Challenge to login.
     * @param challenge Challenge ID from oauth2 flow (required)
     * @param adminConsentAcceptRequest  (optional)
     * @return ApiResponse&lt;AdminRedirectTo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AdminRedirectTo> adminAcceptConsentWithHttpInfo(String challenge, AdminConsentAcceptRequest adminConsentAcceptRequest) throws ApiException {
        okhttp3.Call localVarCall = adminAcceptConsentValidateBeforeCall(challenge, adminConsentAcceptRequest, null);
        Type localVarReturnType = new TypeToken<AdminRedirectTo>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Accept Consent Challenge to login.
     * @param challenge Challenge ID from oauth2 flow (required)
     * @param adminConsentAcceptRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminAcceptConsentAsync(String challenge, AdminConsentAcceptRequest adminConsentAcceptRequest, final ApiCallback<AdminRedirectTo> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminAcceptConsentValidateBeforeCall(challenge, adminConsentAcceptRequest, _callback);
        Type localVarReturnType = new TypeToken<AdminRedirectTo>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for adminAcceptLogin
     * @param loginChallenge Login Challenge ID from oauth2 flow (required)
     * @param adminLoginAcceptRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminAcceptLoginCall(String loginChallenge, AdminLoginAcceptRequest adminLoginAcceptRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = adminLoginAcceptRequest;

        // create path and map variables
        String localVarPath = "/oauth2/auth/requests/login/accept";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (loginChallenge != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("login_challenge", loginChallenge));
        }

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/vnd.api+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2Internal" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call adminAcceptLoginValidateBeforeCall(String loginChallenge, AdminLoginAcceptRequest adminLoginAcceptRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'loginChallenge' is set
        if (loginChallenge == null) {
            throw new ApiException("Missing the required parameter 'loginChallenge' when calling adminAcceptLogin(Async)");
        }
        
        // verify the required parameter 'adminLoginAcceptRequest' is set
        if (adminLoginAcceptRequest == null) {
            throw new ApiException("Missing the required parameter 'adminLoginAcceptRequest' when calling adminAcceptLogin(Async)");
        }
        

        okhttp3.Call localVarCall = adminAcceptLoginCall(loginChallenge, adminLoginAcceptRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Accept Login Challenge with subject &amp; login challenge
     * @param loginChallenge Login Challenge ID from oauth2 flow (required)
     * @param adminLoginAcceptRequest  (required)
     * @return AdminRedirectTo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public AdminRedirectTo adminAcceptLogin(String loginChallenge, AdminLoginAcceptRequest adminLoginAcceptRequest) throws ApiException {
        ApiResponse<AdminRedirectTo> localVarResp = adminAcceptLoginWithHttpInfo(loginChallenge, adminLoginAcceptRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * Accept Login Challenge with subject &amp; login challenge
     * @param loginChallenge Login Challenge ID from oauth2 flow (required)
     * @param adminLoginAcceptRequest  (required)
     * @return ApiResponse&lt;AdminRedirectTo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AdminRedirectTo> adminAcceptLoginWithHttpInfo(String loginChallenge, AdminLoginAcceptRequest adminLoginAcceptRequest) throws ApiException {
        okhttp3.Call localVarCall = adminAcceptLoginValidateBeforeCall(loginChallenge, adminLoginAcceptRequest, null);
        Type localVarReturnType = new TypeToken<AdminRedirectTo>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Accept Login Challenge with subject &amp; login challenge
     * @param loginChallenge Login Challenge ID from oauth2 flow (required)
     * @param adminLoginAcceptRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call adminAcceptLoginAsync(String loginChallenge, AdminLoginAcceptRequest adminLoginAcceptRequest, final ApiCallback<AdminRedirectTo> _callback) throws ApiException {

        okhttp3.Call localVarCall = adminAcceptLoginValidateBeforeCall(loginChallenge, adminLoginAcceptRequest, _callback);
        Type localVarReturnType = new TypeToken<AdminRedirectTo>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createToken
     * @param grantType  (required)
     * @param scope  (optional)
     * @param code  (optional)
     * @param redirectUri  (optional)
     * @param refreshToken  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid or missing request. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTokenCall(String grantType, String scope, String code, String redirectUri, String refreshToken, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/oauth2/token";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (scope != null) {
            localVarFormParams.put("scope", scope);
        }

        if (code != null) {
            localVarFormParams.put("code", code);
        }

        if (redirectUri != null) {
            localVarFormParams.put("redirect_uri", redirectUri);
        }

        if (grantType != null) {
            localVarFormParams.put("grant_type", grantType);
        }

        if (refreshToken != null) {
            localVarFormParams.put("refresh_token", refreshToken);
        }

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/x-www-form-urlencoded"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTokenValidateBeforeCall(String grantType, String scope, String code, String redirectUri, String refreshToken, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'grantType' is set
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling createToken(Async)");
        }
        

        okhttp3.Call localVarCall = createTokenCall(grantType, scope, code, redirectUri, refreshToken, _callback);
        return localVarCall;

    }

    /**
     * 
     * Create an OAuth2 access token. For details, see our [Authentication](https://developer.vertexvis.com/docs/guides/authentication) guide.
     * @param grantType  (required)
     * @param scope  (optional)
     * @param code  (optional)
     * @param redirectUri  (optional)
     * @param refreshToken  (optional)
     * @return OAuth2Token
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid or missing request. </td><td>  -  </td></tr>
     </table>
     */
    public OAuth2Token createToken(String grantType, String scope, String code, String redirectUri, String refreshToken) throws ApiException {
        ApiResponse<OAuth2Token> localVarResp = createTokenWithHttpInfo(grantType, scope, code, redirectUri, refreshToken);
        return localVarResp.getData();
    }

    /**
     * 
     * Create an OAuth2 access token. For details, see our [Authentication](https://developer.vertexvis.com/docs/guides/authentication) guide.
     * @param grantType  (required)
     * @param scope  (optional)
     * @param code  (optional)
     * @param redirectUri  (optional)
     * @param refreshToken  (optional)
     * @return ApiResponse&lt;OAuth2Token&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid or missing request. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OAuth2Token> createTokenWithHttpInfo(String grantType, String scope, String code, String redirectUri, String refreshToken) throws ApiException {
        okhttp3.Call localVarCall = createTokenValidateBeforeCall(grantType, scope, code, redirectUri, refreshToken, null);
        Type localVarReturnType = new TypeToken<OAuth2Token>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Create an OAuth2 access token. For details, see our [Authentication](https://developer.vertexvis.com/docs/guides/authentication) guide.
     * @param grantType  (required)
     * @param scope  (optional)
     * @param code  (optional)
     * @param redirectUri  (optional)
     * @param refreshToken  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Invalid or missing request. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTokenAsync(String grantType, String scope, String code, String redirectUri, String refreshToken, final ApiCallback<OAuth2Token> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTokenValidateBeforeCall(grantType, scope, code, redirectUri, refreshToken, _callback);
        Type localVarReturnType = new TypeToken<OAuth2Token>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for revokeToken
     * @param revokeOAuth2TokenRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeTokenCall(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = revokeOAuth2TokenRequest;

        // create path and map variables
        String localVarPath = "/oauth2/revoke";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/vnd.api+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call revokeTokenValidateBeforeCall(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'revokeOAuth2TokenRequest' is set
        if (revokeOAuth2TokenRequest == null) {
            throw new ApiException("Missing the required parameter 'revokeOAuth2TokenRequest' when calling revokeToken(Async)");
        }
        

        okhttp3.Call localVarCall = revokeTokenCall(revokeOAuth2TokenRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Revoke an OAuth2 access token.
     * @param revokeOAuth2TokenRequest  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void revokeToken(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest) throws ApiException {
        revokeTokenWithHttpInfo(revokeOAuth2TokenRequest);
    }

    /**
     * 
     * Revoke an OAuth2 access token.
     * @param revokeOAuth2TokenRequest  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> revokeTokenWithHttpInfo(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest) throws ApiException {
        okhttp3.Call localVarCall = revokeTokenValidateBeforeCall(revokeOAuth2TokenRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Revoke an OAuth2 access token.
     * @param revokeOAuth2TokenRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeTokenAsync(RevokeOAuth2TokenRequest revokeOAuth2TokenRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = revokeTokenValidateBeforeCall(revokeOAuth2TokenRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
