/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples:   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.model.CADExportConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * CreateExportRequestDataAttributes
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CreateExportRequestDataAttributes {
  public static final String SERIALIZED_NAME_CONFIG = "config";
  @SerializedName(SERIALIZED_NAME_CONFIG)
  private OneOfCADExportConfig config;

  public static final String SERIALIZED_NAME_FILE_NAME = "fileName";
  @SerializedName(SERIALIZED_NAME_FILE_NAME)
  private String fileName;

  public CreateExportRequestDataAttributes() { 
  }

  public CreateExportRequestDataAttributes config(OneOfCADExportConfig config) {
    
    this.config = config;
    return this;
  }

   /**
   * Specifies the export format and options to configure the export.
   * @return config
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(required = true, value = "Specifies the export format and options to configure the export.")

  public OneOfCADExportConfig getConfig() {
    return config;
  }


  public void setConfig(OneOfCADExportConfig config) {
    this.config = config;
  }


  public CreateExportRequestDataAttributes fileName(String fileName) {
    
    this.fileName = fileName;
    return this;
  }

   /**
   * Optional file name to use for the resulting export
   * @return fileName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "exportedScene", value = "Optional file name to use for the resulting export")

  public String getFileName() {
    return fileName;
  }


  public void setFileName(String fileName) {
    this.fileName = fileName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateExportRequestDataAttributes createExportRequestDataAttributes = (CreateExportRequestDataAttributes) o;
    return Objects.equals(this.config, createExportRequestDataAttributes.config) &&
        Objects.equals(this.fileName, createExportRequestDataAttributes.fileName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(config, fileName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateExportRequestDataAttributes {\n");
    sb.append("    config: ").append(toIndentedString(config)).append("\n");
    sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

