/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SceneCreatedEvent {
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_TOPIC = "topic";
    @SerializedName(value="topic")
    private String topic;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;

    public SceneCreatedEvent created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2020-01-01T12:00Z", required=true, value="")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public SceneCreatedEvent topic(String topic) {
        this.topic = topic;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="some-string", required=true, value="")
    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public SceneCreatedEvent metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public SceneCreatedEvent putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User supplied key-value pairs for a scene. You can supply up to 50 entries, with key names limited to 64 characters and values limited to 256 characters. ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SceneCreatedEvent sceneCreatedEvent = (SceneCreatedEvent)o;
        return Objects.equals(this.created, sceneCreatedEvent.created) && Objects.equals(this.topic, sceneCreatedEvent.topic) && Objects.equals(this.metadata, sceneCreatedEvent.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.topic, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SceneCreatedEvent {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    topic: ").append(this.toIndentedString(this.topic)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

