/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import com.vertexvis.model.CrossSectioning;
import com.vertexvis.model.OneOfPerspectiveCameraOrthographicCamera;
import com.vertexvis.model.Orientation;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class SceneViewDataAttributes {
    public static final String SERIALIZED_NAME_CAMERA = "camera";
    @SerializedName(value="camera")
    private OneOfPerspectiveCameraOrthographicCamera camera;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_CROSS_SECTIONING = "crossSectioning";
    @SerializedName(value="crossSectioning")
    private CrossSectioning crossSectioning;
    public static final String SERIALIZED_NAME_WORLD_ORIENTATION = "worldOrientation";
    @SerializedName(value="worldOrientation")
    private Orientation worldOrientation;
    public static final String SERIALIZED_NAME_EXCLUDE_PRUNED_ITEMS = "excludePrunedItems";
    @SerializedName(value="excludePrunedItems")
    private Boolean excludePrunedItems;

    public SceneViewDataAttributes camera(OneOfPerspectiveCameraOrthographicCamera camera) {
        this.camera = camera;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public OneOfPerspectiveCameraOrthographicCamera getCamera() {
        return this.camera;
    }

    public void setCamera(OneOfPerspectiveCameraOrthographicCamera camera) {
        this.camera = camera;
    }

    public SceneViewDataAttributes created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2020-01-01T12:00Z", required=true, value="")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public SceneViewDataAttributes crossSectioning(CrossSectioning crossSectioning) {
        this.crossSectioning = crossSectioning;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CrossSectioning getCrossSectioning() {
        return this.crossSectioning;
    }

    public void setCrossSectioning(CrossSectioning crossSectioning) {
        this.crossSectioning = crossSectioning;
    }

    public SceneViewDataAttributes worldOrientation(Orientation worldOrientation) {
        this.worldOrientation = worldOrientation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Orientation getWorldOrientation() {
        return this.worldOrientation;
    }

    public void setWorldOrientation(Orientation worldOrientation) {
        this.worldOrientation = worldOrientation;
    }

    public SceneViewDataAttributes excludePrunedItems(Boolean excludePrunedItems) {
        this.excludePrunedItems = excludePrunedItems;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether to exclude non-visible items in the view")
    public Boolean getExcludePrunedItems() {
        return this.excludePrunedItems;
    }

    public void setExcludePrunedItems(Boolean excludePrunedItems) {
        this.excludePrunedItems = excludePrunedItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SceneViewDataAttributes sceneViewDataAttributes = (SceneViewDataAttributes)o;
        return Objects.equals(this.camera, sceneViewDataAttributes.camera) && Objects.equals(this.created, sceneViewDataAttributes.created) && Objects.equals(this.crossSectioning, sceneViewDataAttributes.crossSectioning) && Objects.equals(this.worldOrientation, sceneViewDataAttributes.worldOrientation) && Objects.equals(this.excludePrunedItems, sceneViewDataAttributes.excludePrunedItems);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.camera, this.created, this.crossSectioning, this.worldOrientation, this.excludePrunedItems);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SceneViewDataAttributes {\n");
        sb.append("    camera: ").append(this.toIndentedString(this.camera)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    crossSectioning: ").append(this.toIndentedString(this.crossSectioning)).append("\n");
        sb.append("    worldOrientation: ").append(this.toIndentedString(this.worldOrientation)).append("\n");
        sb.append("    excludePrunedItems: ").append(this.toIndentedString(this.excludePrunedItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

