/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model.serialization;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.model.Camera;
import com.vertexvis.model.OneOfPerspectiveCameraOrthographicCamera;
import com.vertexvis.model.OrthographicCamera;
import com.vertexvis.model.PerspectiveCamera;
import java.io.IOException;
import java.util.function.Supplier;

public class OneOfPerspectiveCameraOrthographicCameraTypeAdapter
extends TypeAdapter<OneOfPerspectiveCameraOrthographicCamera> {
    private final Supplier<Gson> gsonSupplier;

    public OneOfPerspectiveCameraOrthographicCameraTypeAdapter(Supplier<Gson> gsonSupplier) {
        this.gsonSupplier = gsonSupplier;
    }

    public void write(JsonWriter out, OneOfPerspectiveCameraOrthographicCamera value) throws IOException {
        if (value != null && value.getData() != null) {
            out.jsonValue(this.gsonSupplier.get().toJson(value.getData()));
        } else {
            out.jsonValue(null);
        }
    }

    public OneOfPerspectiveCameraOrthographicCamera read(JsonReader in) throws IOException {
        Camera camera = (Camera)this.gsonSupplier.get().fromJson(in, TypeToken.get(Camera.class).getType());
        OneOfPerspectiveCameraOrthographicCamera oneOfCamera = null;
        switch (camera.getType()) {
            case "perspective": {
                oneOfCamera = new OneOfPerspectiveCameraOrthographicCamera(new PerspectiveCamera().type(camera.getType()).position(camera.getPosition()).lookAt(camera.getLookAt()).up(camera.getUp()));
                break;
            }
            case "orthographic": {
                oneOfCamera = new OneOfPerspectiveCameraOrthographicCamera(new OrthographicCamera().type(camera.getType()).viewVector(camera.getViewVector()).lookAt(camera.getLookAt()).up(camera.getUp()).fovHeight(camera.getFovHeight()));
            }
        }
        return oneOfCamera;
    }
}

