/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.example;

import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.api.FilesApi;
import com.vertexvis.example.CallbackUtil;
import com.vertexvis.example.MetadataUtil;
import com.vertexvis.example.PartCreator;
import com.vertexvis.example.SceneCreator;
import com.vertexvis.example.cmdline.CommandLineOptions;
import com.vertexvis.model.AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType;
import com.vertexvis.model.CreateFileRequest;
import com.vertexvis.model.CreateFileRequestData;
import com.vertexvis.model.CreateFileRequestDataAttributes;
import com.vertexvis.model.FileMetadata;
import com.vertexvis.model.Part;
import com.vertexvis.model.PartDataRelationshipsPartRevisions;
import com.vertexvis.model.Scene;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import picocli.CommandLine;

public class CreatePartRevisionsWithMetadataExample
extends CommandLineOptions {
    private static final Logger logger = Logger.getLogger(CreatePartRevisionsWithMetadataExample.class.getName());

    @Override
    public void run() {
        String clientId = this.getClientId();
        String secret = this.getClientSecret();
        if (CreatePartRevisionsWithMetadataExample.isNullOrEmpty(clientId) || CreatePartRevisionsWithMetadataExample.isNullOrEmpty(secret)) {
            throw new CommandLine.ParameterException(this.getSpec().commandLine(), "Environment variables [VERTEX_CLIENT_ID] [VERTEX_CLIENT_SECRET] or command line options [--clientId][--clientSecret]containing your Vertex client ID and secret are required.");
        }
        ApiClient client = new ApiClient(this.getVertexApiUrl(), clientId, secret, new HashMap<String, String>()).setDebugging(this.isVerboseDebugLogging());
        PartCreator pc = new PartCreator(client);
        FilesApi files = new FilesApi(client);
        SceneCreator sc = new SceneCreator(client);
        Map<String, AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType> partMetadata = MetadataUtil.createCustomMetadata(this.getMetadataCount());
        List<CompletableFuture> futureParts = this.getPartFiles().stream().map(CreatePartRevisionsWithMetadataExample::buildCreateFileReq).map(req -> CreatePartRevisionsWithMetadataExample.createAndUploadFile(files, req).thenCompose(partId -> pc.createPartFromFileAsync((UUID)partId, (CreateFileRequest)req, partMetadata))).toList();
        CompletableFuture.allOf(futureParts.toArray(new CompletableFuture[0])).join();
        List<Part> newParts = futureParts.stream().map(CompletableFuture::join).toList();
        newParts.forEach(p -> logger.info("Created part: " + p.getData().getId() + " with name " + p.getData().getAttributes().getName()));
        try {
            Part assembly = (Part)((CompletableFuture)newParts.stream().map(part -> part.getData().getRelationships().getPartRevisions()).flatMap(Collection::stream).map(PartDataRelationshipsPartRevisions::getId).peek(uuid -> logger.info("Part Revision Id: " + uuid)).collect(Collectors.collectingAndThen(Collectors.toList(), l -> pc.createAssemblyFromRevisions((List<UUID>)l, this.getAssemblyName()))).handle((part, ex) -> {
                if (ex != null) {
                    if (ex.getCause() instanceof ApiException) {
                        logger.log(Level.SEVERE, ((ApiException)ex.getCause()).getResponseBody(), ex.getCause());
                    }
                    logger.log(Level.SEVERE, ex.getCause().getMessage(), (Throwable)ex);
                    return null;
                }
                return part;
            })).join();
            logger.info("Created assembly: " + assembly.getData().getId() + " with name " + assembly.getData().getAttributes().getName());
            Scene scene = sc.createSceneFromPart(assembly);
            logger.info("Created scene: " + scene.getData().getId() + " with name " + scene.getData().getAttributes().getName());
            logger.info("Each Part Revision has: " + this.getMetadataCount() + " custom metadata items");
        }
        catch (ApiException e) {
            logger.log(Level.SEVERE, "Error Code [" + e.getCode() + "], Response body " + e.getResponseBody(), e);
        }
        catch (InterruptedException e) {
            logger.severe(e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new CreatePartRevisionsWithMetadataExample()).execute(args);
        System.exit(exitCode);
    }

    private static CompletableFuture<UUID> createAndUploadFile(FilesApi files, CreateFileRequest req) {
        return CallbackUtil.execute(fmdCB -> files.createFileAsync(req, (ApiCallback<FileMetadata>)fmdCB)).thenCompose(md -> CreatePartRevisionsWithMetadataExample.uploadFile(files, md.getData().getAttributes().getName(), md.getData().getId()));
    }

    private static CompletableFuture<UUID> uploadFile(FilesApi files, String name, UUID id) {
        return CallbackUtil.execute(uCB -> files.uploadFileAsync(id, new File(name), (ApiCallback<Void>)uCB)).thenApply(Void2 -> id);
    }

    private static CreateFileRequest buildCreateFileReq(String fileName) {
        return new CreateFileRequest().data(new CreateFileRequestData().type("file").attributes(new CreateFileRequestDataAttributes().name(fileName)));
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

