/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples:   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.api;

import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.ProgressRequestBody;
import com.vertexvis.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.vertexvis.model.CreateSceneAnnotationRequest;
import com.vertexvis.model.CreateSceneAnnotationSetRequest;
import com.vertexvis.model.Failure;
import com.vertexvis.model.SceneAnnotation;
import com.vertexvis.model.SceneAnnotationSet;
import com.vertexvis.model.SceneAnnotationSetList;
import java.util.UUID;
import com.vertexvis.model.UpdateSceneAnnotationRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SceneAnnotationsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SceneAnnotationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SceneAnnotationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createSceneAnnotation
     * @param id The &#x60;scene-annotation-set&#x60; ID. (required)
     * @param createSceneAnnotationRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSceneAnnotationCall(UUID id, CreateSceneAnnotationRequest createSceneAnnotationRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createSceneAnnotationRequest;

        // create path and map variables
        String localVarPath = "/scene-annotation-sets/{id}/scene-annotations"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/vnd.api+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createSceneAnnotationValidateBeforeCall(UUID id, CreateSceneAnnotationRequest createSceneAnnotationRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createSceneAnnotation(Async)");
        }
        
        // verify the required parameter 'createSceneAnnotationRequest' is set
        if (createSceneAnnotationRequest == null) {
            throw new ApiException("Missing the required parameter 'createSceneAnnotationRequest' when calling createSceneAnnotation(Async)");
        }
        

        okhttp3.Call localVarCall = createSceneAnnotationCall(id, createSceneAnnotationRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Create an annotation belonging to an annotation set. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene-annotation-set&#x60; ID. (required)
     * @param createSceneAnnotationRequest  (required)
     * @return SceneAnnotation
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public SceneAnnotation createSceneAnnotation(UUID id, CreateSceneAnnotationRequest createSceneAnnotationRequest) throws ApiException {
        ApiResponse<SceneAnnotation> localVarResp = createSceneAnnotationWithHttpInfo(id, createSceneAnnotationRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * Create an annotation belonging to an annotation set. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene-annotation-set&#x60; ID. (required)
     * @param createSceneAnnotationRequest  (required)
     * @return ApiResponse&lt;SceneAnnotation&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SceneAnnotation> createSceneAnnotationWithHttpInfo(UUID id, CreateSceneAnnotationRequest createSceneAnnotationRequest) throws ApiException {
        okhttp3.Call localVarCall = createSceneAnnotationValidateBeforeCall(id, createSceneAnnotationRequest, null);
        Type localVarReturnType = new TypeToken<SceneAnnotation>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Create an annotation belonging to an annotation set. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene-annotation-set&#x60; ID. (required)
     * @param createSceneAnnotationRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSceneAnnotationAsync(UUID id, CreateSceneAnnotationRequest createSceneAnnotationRequest, final ApiCallback<SceneAnnotation> _callback) throws ApiException {

        okhttp3.Call localVarCall = createSceneAnnotationValidateBeforeCall(id, createSceneAnnotationRequest, _callback);
        Type localVarReturnType = new TypeToken<SceneAnnotation>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createSceneAnnotationSet
     * @param id The &#x60;scene&#x60; ID. (required)
     * @param createSceneAnnotationSetRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSceneAnnotationSetCall(UUID id, CreateSceneAnnotationSetRequest createSceneAnnotationSetRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createSceneAnnotationSetRequest;

        // create path and map variables
        String localVarPath = "/scenes/{id}/scene-annotation-sets"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/vnd.api+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createSceneAnnotationSetValidateBeforeCall(UUID id, CreateSceneAnnotationSetRequest createSceneAnnotationSetRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createSceneAnnotationSet(Async)");
        }
        
        // verify the required parameter 'createSceneAnnotationSetRequest' is set
        if (createSceneAnnotationSetRequest == null) {
            throw new ApiException("Missing the required parameter 'createSceneAnnotationSetRequest' when calling createSceneAnnotationSet(Async)");
        }
        

        okhttp3.Call localVarCall = createSceneAnnotationSetCall(id, createSceneAnnotationSetRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Create an annotation set that is associated with a scene. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene&#x60; ID. (required)
     * @param createSceneAnnotationSetRequest  (required)
     * @return SceneAnnotationSet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public SceneAnnotationSet createSceneAnnotationSet(UUID id, CreateSceneAnnotationSetRequest createSceneAnnotationSetRequest) throws ApiException {
        ApiResponse<SceneAnnotationSet> localVarResp = createSceneAnnotationSetWithHttpInfo(id, createSceneAnnotationSetRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * Create an annotation set that is associated with a scene. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene&#x60; ID. (required)
     * @param createSceneAnnotationSetRequest  (required)
     * @return ApiResponse&lt;SceneAnnotationSet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SceneAnnotationSet> createSceneAnnotationSetWithHttpInfo(UUID id, CreateSceneAnnotationSetRequest createSceneAnnotationSetRequest) throws ApiException {
        okhttp3.Call localVarCall = createSceneAnnotationSetValidateBeforeCall(id, createSceneAnnotationSetRequest, null);
        Type localVarReturnType = new TypeToken<SceneAnnotationSet>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Create an annotation set that is associated with a scene. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene&#x60; ID. (required)
     * @param createSceneAnnotationSetRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  * location -  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSceneAnnotationSetAsync(UUID id, CreateSceneAnnotationSetRequest createSceneAnnotationSetRequest, final ApiCallback<SceneAnnotationSet> _callback) throws ApiException {

        okhttp3.Call localVarCall = createSceneAnnotationSetValidateBeforeCall(id, createSceneAnnotationSetRequest, _callback);
        Type localVarReturnType = new TypeToken<SceneAnnotationSet>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteSceneAnnotation
     * @param id The &#x60;scene-annotation&#x60; ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteSceneAnnotationCall(UUID id, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/scene-annotations/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteSceneAnnotationValidateBeforeCall(UUID id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteSceneAnnotation(Async)");
        }
        

        okhttp3.Call localVarCall = deleteSceneAnnotationCall(id, _callback);
        return localVarCall;

    }

    /**
     * 
     * Delete a scene annotation. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene-annotation&#x60; ID. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public void deleteSceneAnnotation(UUID id) throws ApiException {
        deleteSceneAnnotationWithHttpInfo(id);
    }

    /**
     * 
     * Delete a scene annotation. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene-annotation&#x60; ID. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteSceneAnnotationWithHttpInfo(UUID id) throws ApiException {
        okhttp3.Call localVarCall = deleteSceneAnnotationValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Delete a scene annotation. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene-annotation&#x60; ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteSceneAnnotationAsync(UUID id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteSceneAnnotationValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSceneAnnotationSets
     * @param id The &#x60;scene&#x60; ID. (required)
     * @param pageCursor The cursor for the next page of items. (optional)
     * @param pageSize The number of items to return. (optional)
     * @param filterId Comma-separated list of IDs to filter on. (optional)
     * @param filterSuppliedId Comma-separated list of supplied IDs to filter on. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSceneAnnotationSetsCall(UUID id, String pageCursor, Integer pageSize, String filterId, String filterSuppliedId, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/scenes/{id}/scene-annotation-sets"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (pageCursor != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }

        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page[size]", pageSize));
        }

        if (filterId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter[id]", filterId));
        }

        if (filterSuppliedId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter[suppliedId]", filterSuppliedId));
        }

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSceneAnnotationSetsValidateBeforeCall(UUID id, String pageCursor, Integer pageSize, String filterId, String filterSuppliedId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSceneAnnotationSets(Async)");
        }
        

        okhttp3.Call localVarCall = getSceneAnnotationSetsCall(id, pageCursor, pageSize, filterId, filterSuppliedId, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get &#x60;scene-annotation-sets&#x60; for a &#x60;scene&#x60;.
     * @param id The &#x60;scene&#x60; ID. (required)
     * @param pageCursor The cursor for the next page of items. (optional)
     * @param pageSize The number of items to return. (optional)
     * @param filterId Comma-separated list of IDs to filter on. (optional)
     * @param filterSuppliedId Comma-separated list of supplied IDs to filter on. (optional)
     * @return SceneAnnotationSetList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public SceneAnnotationSetList getSceneAnnotationSets(UUID id, String pageCursor, Integer pageSize, String filterId, String filterSuppliedId) throws ApiException {
        ApiResponse<SceneAnnotationSetList> localVarResp = getSceneAnnotationSetsWithHttpInfo(id, pageCursor, pageSize, filterId, filterSuppliedId);
        return localVarResp.getData();
    }

    /**
     * 
     * Get &#x60;scene-annotation-sets&#x60; for a &#x60;scene&#x60;.
     * @param id The &#x60;scene&#x60; ID. (required)
     * @param pageCursor The cursor for the next page of items. (optional)
     * @param pageSize The number of items to return. (optional)
     * @param filterId Comma-separated list of IDs to filter on. (optional)
     * @param filterSuppliedId Comma-separated list of supplied IDs to filter on. (optional)
     * @return ApiResponse&lt;SceneAnnotationSetList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SceneAnnotationSetList> getSceneAnnotationSetsWithHttpInfo(UUID id, String pageCursor, Integer pageSize, String filterId, String filterSuppliedId) throws ApiException {
        okhttp3.Call localVarCall = getSceneAnnotationSetsValidateBeforeCall(id, pageCursor, pageSize, filterId, filterSuppliedId, null);
        Type localVarReturnType = new TypeToken<SceneAnnotationSetList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get &#x60;scene-annotation-sets&#x60; for a &#x60;scene&#x60;.
     * @param id The &#x60;scene&#x60; ID. (required)
     * @param pageCursor The cursor for the next page of items. (optional)
     * @param pageSize The number of items to return. (optional)
     * @param filterId Comma-separated list of IDs to filter on. (optional)
     * @param filterSuppliedId Comma-separated list of supplied IDs to filter on. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSceneAnnotationSetsAsync(UUID id, String pageCursor, Integer pageSize, String filterId, String filterSuppliedId, final ApiCallback<SceneAnnotationSetList> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSceneAnnotationSetsValidateBeforeCall(id, pageCursor, pageSize, filterId, filterSuppliedId, _callback);
        Type localVarReturnType = new TypeToken<SceneAnnotationSetList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateSceneAnnotation
     * @param id The &#x60;scene-annotation&#x60; ID. (required)
     * @param updateSceneAnnotationRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSceneAnnotationCall(UUID id, UpdateSceneAnnotationRequest updateSceneAnnotationRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateSceneAnnotationRequest;

        // create path and map variables
        String localVarPath = "/scene-annotations/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.api+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/vnd.api+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateSceneAnnotationValidateBeforeCall(UUID id, UpdateSceneAnnotationRequest updateSceneAnnotationRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSceneAnnotation(Async)");
        }
        
        // verify the required parameter 'updateSceneAnnotationRequest' is set
        if (updateSceneAnnotationRequest == null) {
            throw new ApiException("Missing the required parameter 'updateSceneAnnotationRequest' when calling updateSceneAnnotation(Async)");
        }
        

        okhttp3.Call localVarCall = updateSceneAnnotationCall(id, updateSceneAnnotationRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Update the attributes of an annotation. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene-annotation&#x60; ID. (required)
     * @param updateSceneAnnotationRequest  (required)
     * @return SceneAnnotation
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public SceneAnnotation updateSceneAnnotation(UUID id, UpdateSceneAnnotationRequest updateSceneAnnotationRequest) throws ApiException {
        ApiResponse<SceneAnnotation> localVarResp = updateSceneAnnotationWithHttpInfo(id, updateSceneAnnotationRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * Update the attributes of an annotation. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene-annotation&#x60; ID. (required)
     * @param updateSceneAnnotationRequest  (required)
     * @return ApiResponse&lt;SceneAnnotation&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SceneAnnotation> updateSceneAnnotationWithHttpInfo(UUID id, UpdateSceneAnnotationRequest updateSceneAnnotationRequest) throws ApiException {
        okhttp3.Call localVarCall = updateSceneAnnotationValidateBeforeCall(id, updateSceneAnnotationRequest, null);
        Type localVarReturnType = new TypeToken<SceneAnnotation>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Update the attributes of an annotation. **Preview:** This is a preview API and is subject to change. 
     * @param id The &#x60;scene-annotation&#x60; ID. (required)
     * @param updateSceneAnnotationRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSceneAnnotationAsync(UUID id, UpdateSceneAnnotationRequest updateSceneAnnotationRequest, final ApiCallback<SceneAnnotation> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateSceneAnnotationValidateBeforeCall(id, updateSceneAnnotationRequest, _callback);
        Type localVarReturnType = new TypeToken<SceneAnnotation>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
