/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples:   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * CreateDownloadRequestDataAttributes
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CreateDownloadRequestDataAttributes {
  public static final String SERIALIZED_NAME_EXPIRY = "expiry";
  @SerializedName(SERIALIZED_NAME_EXPIRY)
  private Integer expiry;

  public static final String SERIALIZED_NAME_MAX_AGE = "maxAge";
  @SerializedName(SERIALIZED_NAME_MAX_AGE)
  private Integer maxAge;

  public CreateDownloadRequestDataAttributes() { 
  }

  public CreateDownloadRequestDataAttributes expiry(Integer expiry) {
    
    this.expiry = expiry;
    return this;
  }

   /**
   * Specifies the duration for which this pre-signed request should be valid. After this time has expired, attempting to use the presigned request will fail. (Defaults to 1 hour, max value is 24 hours)
   * minimum: 1
   * maximum: 86400
   * @return expiry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "3600", value = "Specifies the duration for which this pre-signed request should be valid. After this time has expired, attempting to use the presigned request will fail. (Defaults to 1 hour, max value is 24 hours)")

  public Integer getExpiry() {
    return expiry;
  }


  public void setExpiry(Integer expiry) {
    this.expiry = expiry;
  }


  public CreateDownloadRequestDataAttributes maxAge(Integer maxAge) {
    
    this.maxAge = maxAge;
    return this;
  }

   /**
   * Specifies the maximum time (in seconds) a cached response of a signed-url remains fresh and can be used without revalidation. (Defaults to 1 hour, can send up to 30 days)
   * minimum: 1
   * maximum: 2592000
   * @return maxAge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1000", value = "Specifies the maximum time (in seconds) a cached response of a signed-url remains fresh and can be used without revalidation. (Defaults to 1 hour, can send up to 30 days)")

  public Integer getMaxAge() {
    return maxAge;
  }


  public void setMaxAge(Integer maxAge) {
    this.maxAge = maxAge;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateDownloadRequestDataAttributes createDownloadRequestDataAttributes = (CreateDownloadRequestDataAttributes) o;
    return Objects.equals(this.expiry, createDownloadRequestDataAttributes.expiry) &&
        Objects.equals(this.maxAge, createDownloadRequestDataAttributes.maxAge);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expiry, maxAge);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateDownloadRequestDataAttributes {\n");
    sb.append("    expiry: ").append(toIndentedString(expiry)).append("\n");
    sb.append("    maxAge: ").append(toIndentedString(maxAge)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

