/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples:   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.UUID;

/**
 * CreateStreamKeyRequestDataAttributes
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CreateStreamKeyRequestDataAttributes {
  public static final String SERIALIZED_NAME_EXPIRY = "expiry";
  @SerializedName(SERIALIZED_NAME_EXPIRY)
  private Integer expiry;

  public static final String SERIALIZED_NAME_EXCLUDE_PRUNED_ITEMS = "excludePrunedItems";
  @SerializedName(SERIALIZED_NAME_EXCLUDE_PRUNED_ITEMS)
  private Boolean excludePrunedItems;

  public static final String SERIALIZED_NAME_SCENE_VIEW_STATE_SUPPLIED_ID = "sceneViewStateSuppliedId";
  @SerializedName(SERIALIZED_NAME_SCENE_VIEW_STATE_SUPPLIED_ID)
  private String sceneViewStateSuppliedId;

  public static final String SERIALIZED_NAME_SCENE_VIEW_STATE_ID = "sceneViewStateId";
  @SerializedName(SERIALIZED_NAME_SCENE_VIEW_STATE_ID)
  private UUID sceneViewStateId;

  public static final String SERIALIZED_NAME_WITH_SEARCH_SESSION = "withSearchSession";
  @SerializedName(SERIALIZED_NAME_WITH_SEARCH_SESSION)
  private Boolean withSearchSession;

  public CreateStreamKeyRequestDataAttributes() { 
  }

  public CreateStreamKeyRequestDataAttributes expiry(Integer expiry) {
    
    this.expiry = expiry;
    return this;
  }

   /**
   * Number of seconds before the &#x60;stream-key&#x60; expires.
   * minimum: 1
   * maximum: 31557600
   * @return expiry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "600", value = "Number of seconds before the `stream-key` expires.")

  public Integer getExpiry() {
    return expiry;
  }


  public void setExpiry(Integer expiry) {
    this.expiry = expiry;
  }


  public CreateStreamKeyRequestDataAttributes excludePrunedItems(Boolean excludePrunedItems) {
    
    this.excludePrunedItems = excludePrunedItems;
    return this;
  }

   /**
   * Whether to exclude non-visible items in the view.
   * @return excludePrunedItems
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether to exclude non-visible items in the view.")

  public Boolean getExcludePrunedItems() {
    return excludePrunedItems;
  }


  public void setExcludePrunedItems(Boolean excludePrunedItems) {
    this.excludePrunedItems = excludePrunedItems;
  }


  public CreateStreamKeyRequestDataAttributes sceneViewStateSuppliedId(String sceneViewStateSuppliedId) {
    
    this.sceneViewStateSuppliedId = sceneViewStateSuppliedId;
    return this;
  }

   /**
   * An optional supplied ID specifying the &#x60;scene-view-state&#x60; to initialize &#x60;scene-view&#x60;s created using this &#x60;stream-key&#x60; to. Mutually exclusive with &#x60;sceneViewStateId&#x60;.
   * @return sceneViewStateSuppliedId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "some-string", value = "An optional supplied ID specifying the `scene-view-state` to initialize `scene-view`s created using this `stream-key` to. Mutually exclusive with `sceneViewStateId`.")

  public String getSceneViewStateSuppliedId() {
    return sceneViewStateSuppliedId;
  }


  public void setSceneViewStateSuppliedId(String sceneViewStateSuppliedId) {
    this.sceneViewStateSuppliedId = sceneViewStateSuppliedId;
  }


  public CreateStreamKeyRequestDataAttributes sceneViewStateId(UUID sceneViewStateId) {
    
    this.sceneViewStateId = sceneViewStateId;
    return this;
  }

   /**
   * An optional ID specifying the &#x60;scene-view-state&#x60; to initialize &#x60;scene-view&#x60;s created using this &#x60;stream-key&#x60; to. Mutually exclusive with &#x60;sceneViewStateSuppliedId&#x60;.
   * @return sceneViewStateId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "f79d4760-0b71-44e4-ad0b-22743fdd4ca3", value = "An optional ID specifying the `scene-view-state` to initialize `scene-view`s created using this `stream-key` to. Mutually exclusive with `sceneViewStateSuppliedId`.")

  public UUID getSceneViewStateId() {
    return sceneViewStateId;
  }


  public void setSceneViewStateId(UUID sceneViewStateId) {
    this.sceneViewStateId = sceneViewStateId;
  }


  public CreateStreamKeyRequestDataAttributes withSearchSession(Boolean withSearchSession) {
    
    this.withSearchSession = withSearchSession;
    return this;
  }

   /**
   * Optionally enables or disables the creation of a search session for the view.
   * @return withSearchSession
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Optionally enables or disables the creation of a search session for the view.")

  public Boolean getWithSearchSession() {
    return withSearchSession;
  }


  public void setWithSearchSession(Boolean withSearchSession) {
    this.withSearchSession = withSearchSession;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateStreamKeyRequestDataAttributes createStreamKeyRequestDataAttributes = (CreateStreamKeyRequestDataAttributes) o;
    return Objects.equals(this.expiry, createStreamKeyRequestDataAttributes.expiry) &&
        Objects.equals(this.excludePrunedItems, createStreamKeyRequestDataAttributes.excludePrunedItems) &&
        Objects.equals(this.sceneViewStateSuppliedId, createStreamKeyRequestDataAttributes.sceneViewStateSuppliedId) &&
        Objects.equals(this.sceneViewStateId, createStreamKeyRequestDataAttributes.sceneViewStateId) &&
        Objects.equals(this.withSearchSession, createStreamKeyRequestDataAttributes.withSearchSession);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expiry, excludePrunedItems, sceneViewStateSuppliedId, sceneViewStateId, withSearchSession);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateStreamKeyRequestDataAttributes {\n");
    sb.append("    expiry: ").append(toIndentedString(expiry)).append("\n");
    sb.append("    excludePrunedItems: ").append(toIndentedString(excludePrunedItems)).append("\n");
    sb.append("    sceneViewStateSuppliedId: ").append(toIndentedString(sceneViewStateSuppliedId)).append("\n");
    sb.append("    sceneViewStateId: ").append(toIndentedString(sceneViewStateId)).append("\n");
    sb.append("    withSearchSession: ").append(toIndentedString(withSearchSession)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

