/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples:   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * QueryByMetadataDataAttributes
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class QueryByMetadataDataAttributes {
  public static final String SERIALIZED_NAME_EXACT_MATCH = "exactMatch";
  @SerializedName(SERIALIZED_NAME_EXACT_MATCH)
  private Boolean exactMatch;

  public static final String SERIALIZED_NAME_FILTER = "filter";
  @SerializedName(SERIALIZED_NAME_FILTER)
  private String filter;

  public static final String SERIALIZED_NAME_KEYS = "keys";
  @SerializedName(SERIALIZED_NAME_KEYS)
  private List<String> keys = new ArrayList<>();

  public QueryByMetadataDataAttributes() { 
  }

  public QueryByMetadataDataAttributes exactMatch(Boolean exactMatch) {
    
    this.exactMatch = exactMatch;
    return this;
  }

   /**
   * Get exactMatch
   * @return exactMatch
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getExactMatch() {
    return exactMatch;
  }


  public void setExactMatch(Boolean exactMatch) {
    this.exactMatch = exactMatch;
  }


  public QueryByMetadataDataAttributes filter(String filter) {
    
    this.filter = filter;
    return this;
  }

   /**
   * Get filter
   * @return filter
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "some-string", required = true, value = "")

  public String getFilter() {
    return filter;
  }


  public void setFilter(String filter) {
    this.filter = filter;
  }


  public QueryByMetadataDataAttributes keys(List<String> keys) {
    
    this.keys = keys;
    return this;
  }

  public QueryByMetadataDataAttributes addKeysItem(String keysItem) {
    this.keys.add(keysItem);
    return this;
  }

   /**
   * Query &#x60;metadata&#x60;.
   * @return keys
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Query `metadata`.")

  public List<String> getKeys() {
    return keys;
  }


  public void setKeys(List<String> keys) {
    this.keys = keys;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryByMetadataDataAttributes queryByMetadataDataAttributes = (QueryByMetadataDataAttributes) o;
    return Objects.equals(this.exactMatch, queryByMetadataDataAttributes.exactMatch) &&
        Objects.equals(this.filter, queryByMetadataDataAttributes.filter) &&
        Objects.equals(this.keys, queryByMetadataDataAttributes.keys);
  }

  @Override
  public int hashCode() {
    return Objects.hash(exactMatch, filter, keys);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryByMetadataDataAttributes {\n");
    sb.append("    exactMatch: ").append(toIndentedString(exactMatch)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    keys: ").append(toIndentedString(keys)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

