/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples:   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.model.Vector3;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * A type that describes a callout annotation.
 */
@ApiModel(description = "A type that describes a callout annotation.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SceneAnnotationCalloutDataType {
  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_POSITION = "position";
  @SerializedName(SERIALIZED_NAME_POSITION)
  private Vector3 position;

  public static final String SERIALIZED_NAME_ICON = "icon";
  @SerializedName(SERIALIZED_NAME_ICON)
  private String icon;

  public static final String SERIALIZED_NAME_PRIMARY_COLOR = "primaryColor";
  @SerializedName(SERIALIZED_NAME_PRIMARY_COLOR)
  private String primaryColor;

  public static final String SERIALIZED_NAME_ACCENT_COLOR = "accentColor";
  @SerializedName(SERIALIZED_NAME_ACCENT_COLOR)
  private String accentColor;

  public SceneAnnotationCalloutDataType() { 
  }

  public SceneAnnotationCalloutDataType type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of annotation.
   * @return type
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "callout", required = true, value = "The type of annotation.")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public SceneAnnotationCalloutDataType position(Vector3 position) {
    
    this.position = position;
    return this;
  }

   /**
   * Get position
   * @return position
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Vector3 getPosition() {
    return position;
  }


  public void setPosition(Vector3 position) {
    this.position = position;
  }


  public SceneAnnotationCalloutDataType icon(String icon) {
    
    this.icon = icon;
    return this;
  }

   /**
   * An optional icon to display for this annotation. See [documentation](https://github.com/Vertexvis/vertex-web-sdk/tree/master/packages/viewer/src/components/viewer-icon#properties) for possible values. 
   * @return icon
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "comment-show", value = "An optional icon to display for this annotation. See [documentation](https://github.com/Vertexvis/vertex-web-sdk/tree/master/packages/viewer/src/components/viewer-icon#properties) for possible values. ")

  public String getIcon() {
    return icon;
  }


  public void setIcon(String icon) {
    this.icon = icon;
  }


  public SceneAnnotationCalloutDataType primaryColor(String primaryColor) {
    
    this.primaryColor = primaryColor;
    return this;
  }

   /**
   * A hex color value.
   * @return primaryColor
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#FFFFFF", value = "A hex color value.")

  public String getPrimaryColor() {
    return primaryColor;
  }


  public void setPrimaryColor(String primaryColor) {
    this.primaryColor = primaryColor;
  }


  public SceneAnnotationCalloutDataType accentColor(String accentColor) {
    
    this.accentColor = accentColor;
    return this;
  }

   /**
   * A hex color value.
   * @return accentColor
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#FFFFFF", value = "A hex color value.")

  public String getAccentColor() {
    return accentColor;
  }


  public void setAccentColor(String accentColor) {
    this.accentColor = accentColor;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SceneAnnotationCalloutDataType sceneAnnotationCalloutDataType = (SceneAnnotationCalloutDataType) o;
    return Objects.equals(this.type, sceneAnnotationCalloutDataType.type) &&
        Objects.equals(this.position, sceneAnnotationCalloutDataType.position) &&
        Objects.equals(this.icon, sceneAnnotationCalloutDataType.icon) &&
        Objects.equals(this.primaryColor, sceneAnnotationCalloutDataType.primaryColor) &&
        Objects.equals(this.accentColor, sceneAnnotationCalloutDataType.accentColor);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, position, icon, primaryColor, accentColor);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SceneAnnotationCalloutDataType {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    icon: ").append(toIndentedString(icon)).append("\n");
    sb.append("    primaryColor: ").append(toIndentedString(primaryColor)).append("\n");
    sb.append("    accentColor: ").append(toIndentedString(accentColor)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

