/*
 * Vertex Platform API
 * The Vertex distributed cloud rendering platform includes a set of APIs and SDKs, which together allow easily integrating 3D product data into your business application.  See our [Developer Guides](https://developer.vertexvis.com/docs/guides/render-your-first-scene) to get started.  Notes about the Postman collection and API Reference code samples:   - They include all required and optional body parameters for completeness. Remove any optional parameters as desired.   - They use auto-generated IDs and other values that may share the same value for ease of documentation only. In actual requests and responses, the IDs should uniquely identify their corresponding resource. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: support@vertexvis.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.vertexvis.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * A type that describes a custom user provided annotation.
 */
@ApiModel(description = "A type that describes a custom user provided annotation.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SceneAnnotationCustomDataType {
  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_JSON_TYPE = "jsonType";
  @SerializedName(SERIALIZED_NAME_JSON_TYPE)
  private String jsonType;

  public static final String SERIALIZED_NAME_JSON = "json";
  @SerializedName(SERIALIZED_NAME_JSON)
  private String json;

  public SceneAnnotationCustomDataType() { 
  }

  public SceneAnnotationCustomDataType type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of annotation.
   * @return type
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "custom", required = true, value = "The type of annotation.")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public SceneAnnotationCustomDataType jsonType(String jsonType) {
    
    this.jsonType = jsonType;
    return this;
  }

   /**
   * The type of annotation.
   * @return jsonType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "my-annotation-type", required = true, value = "The type of annotation.")

  public String getJsonType() {
    return jsonType;
  }


  public void setJsonType(String jsonType) {
    this.jsonType = jsonType;
  }


  public SceneAnnotationCustomDataType json(String json) {
    
    this.json = json;
    return this;
  }

   /**
   * An encoded JSON string associated with the custom annotation.
   * @return json
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "{\"label\":\"my annotation\",\"anchor\":{\"x\":0,\"y\":0,\"z\":0}}", required = true, value = "An encoded JSON string associated with the custom annotation.")

  public String getJson() {
    return json;
  }


  public void setJson(String json) {
    this.json = json;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SceneAnnotationCustomDataType sceneAnnotationCustomDataType = (SceneAnnotationCustomDataType) o;
    return Objects.equals(this.type, sceneAnnotationCustomDataType.type) &&
        Objects.equals(this.jsonType, sceneAnnotationCustomDataType.jsonType) &&
        Objects.equals(this.json, sceneAnnotationCustomDataType.json);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, jsonType, json);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SceneAnnotationCustomDataType {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    jsonType: ").append(toIndentedString(jsonType)).append("\n");
    sb.append("    json: ").append(toIndentedString(json)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

