/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.api;

import com.google.gson.reflect.TypeToken;
import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.ApiException;
import com.vertexvis.ApiResponse;
import com.vertexvis.Configuration;
import com.vertexvis.Pair;
import com.vertexvis.model.Application;
import com.vertexvis.model.ApplicationList;
import com.vertexvis.model.CreateApplicationRequest;
import com.vertexvis.model.CreatedApplication;
import com.vertexvis.model.UpdateApplicationRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class ApplicationsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ApplicationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createApplicationCall(CreateApplicationRequest createApplicationRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateApplicationRequest localVarPostBody = createApplicationRequest;
        String localVarPath = "/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createApplicationValidateBeforeCall(CreateApplicationRequest createApplicationRequest, ApiCallback _callback) throws ApiException {
        if (createApplicationRequest == null) {
            throw new ApiException("Missing the required parameter 'createApplicationRequest' when calling createApplication(Async)");
        }
        Call localVarCall = this.createApplicationCall(createApplicationRequest, _callback);
        return localVarCall;
    }

    public CreatedApplication createApplication(CreateApplicationRequest createApplicationRequest) throws ApiException {
        ApiResponse<CreatedApplication> localVarResp = this.createApplicationWithHttpInfo(createApplicationRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreatedApplication> createApplicationWithHttpInfo(CreateApplicationRequest createApplicationRequest) throws ApiException {
        Call localVarCall = this.createApplicationValidateBeforeCall(createApplicationRequest, null);
        Type localVarReturnType = new TypeToken<CreatedApplication>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createApplicationAsync(CreateApplicationRequest createApplicationRequest, ApiCallback<CreatedApplication> _callback) throws ApiException {
        Call localVarCall = this.createApplicationValidateBeforeCall(createApplicationRequest, _callback);
        Type localVarReturnType = new TypeToken<CreatedApplication>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteApplicationCall(UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/applications/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteApplicationValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteApplication(Async)");
        }
        Call localVarCall = this.deleteApplicationCall(id, _callback);
        return localVarCall;
    }

    public void deleteApplication(UUID id) throws ApiException {
        this.deleteApplicationWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteApplicationWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.deleteApplicationValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteApplicationAsync(UUID id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteApplicationValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getApplicationCall(UUID id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/applications/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getApplicationValidateBeforeCall(UUID id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getApplication(Async)");
        }
        Call localVarCall = this.getApplicationCall(id, _callback);
        return localVarCall;
    }

    public Application getApplication(UUID id) throws ApiException {
        ApiResponse<Application> localVarResp = this.getApplicationWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Application> getApplicationWithHttpInfo(UUID id) throws ApiException {
        Call localVarCall = this.getApplicationValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getApplicationAsync(UUID id, ApiCallback<Application> _callback) throws ApiException {
        Call localVarCall = this.getApplicationValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getApplicationsCall(String pageCursor, Integer pageSize, String filterClientId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageCursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[cursor]", pageCursor));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page[size]", pageSize));
        }
        if (filterClientId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter[clientId]", filterClientId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getApplicationsValidateBeforeCall(String pageCursor, Integer pageSize, String filterClientId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getApplicationsCall(pageCursor, pageSize, filterClientId, _callback);
        return localVarCall;
    }

    public ApplicationList getApplications(String pageCursor, Integer pageSize, String filterClientId) throws ApiException {
        ApiResponse<ApplicationList> localVarResp = this.getApplicationsWithHttpInfo(pageCursor, pageSize, filterClientId);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationList> getApplicationsWithHttpInfo(String pageCursor, Integer pageSize, String filterClientId) throws ApiException {
        Call localVarCall = this.getApplicationsValidateBeforeCall(pageCursor, pageSize, filterClientId, null);
        Type localVarReturnType = new TypeToken<ApplicationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getApplicationsAsync(String pageCursor, Integer pageSize, String filterClientId, ApiCallback<ApplicationList> _callback) throws ApiException {
        Call localVarCall = this.getApplicationsValidateBeforeCall(pageCursor, pageSize, filterClientId, _callback);
        Type localVarReturnType = new TypeToken<ApplicationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateApplicationCall(UUID id, UpdateApplicationRequest updateApplicationRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateApplicationRequest localVarPostBody = updateApplicationRequest;
        String localVarPath = "/applications/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.api+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateApplicationValidateBeforeCall(UUID id, UpdateApplicationRequest updateApplicationRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateApplication(Async)");
        }
        if (updateApplicationRequest == null) {
            throw new ApiException("Missing the required parameter 'updateApplicationRequest' when calling updateApplication(Async)");
        }
        Call localVarCall = this.updateApplicationCall(id, updateApplicationRequest, _callback);
        return localVarCall;
    }

    public Application updateApplication(UUID id, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
        ApiResponse<Application> localVarResp = this.updateApplicationWithHttpInfo(id, updateApplicationRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Application> updateApplicationWithHttpInfo(UUID id, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
        Call localVarCall = this.updateApplicationValidateBeforeCall(id, updateApplicationRequest, null);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateApplicationAsync(UUID id, UpdateApplicationRequest updateApplicationRequest, ApiCallback<Application> _callback) throws ApiException {
        Call localVarCall = this.updateApplicationValidateBeforeCall(id, updateApplicationRequest, _callback);
        Type localVarReturnType = new TypeToken<Application>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

