/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.example;

import com.vertexvis.ApiCallback;
import com.vertexvis.ApiClient;
import com.vertexvis.api.PartsApi;
import com.vertexvis.api.TranslationInspectionsApi;
import com.vertexvis.example.CallbackUtil;
import com.vertexvis.example.JobPoller;
import com.vertexvis.model.AnyOfFileRelationshipPartAssemblyRelationship;
import com.vertexvis.model.AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType;
import com.vertexvis.model.CreateFileRequest;
import com.vertexvis.model.CreatePartRequest;
import com.vertexvis.model.CreatePartRequestData;
import com.vertexvis.model.CreatePartRequestDataAttributes;
import com.vertexvis.model.CreatePartRequestDataRelationships;
import com.vertexvis.model.FileMetadata;
import com.vertexvis.model.FileRelationship;
import com.vertexvis.model.FileRelationshipData;
import com.vertexvis.model.Matrix4;
import com.vertexvis.model.Part;
import com.vertexvis.model.PartAssemblyRelationship;
import com.vertexvis.model.PartAssemblyRelationshipData;
import com.vertexvis.model.PartRevisionInstance;
import com.vertexvis.model.QueuedJob;
import com.vertexvis.model.Vector4;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class PartCreator {
    private final TranslationInspectionsApi tiApi;
    private final PartsApi parts;

    public PartCreator(ApiClient client) {
        this.parts = new PartsApi(client);
        this.tiApi = new TranslationInspectionsApi(client);
    }

    public Part createPartFromFile(FileMetadata metadata) throws InterruptedException {
        return this.createPartFromFile(metadata, Collections.emptyMap());
    }

    public Part createPartFromFile(FileMetadata metadata, Map<String, AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType> partMetadata) throws InterruptedException {
        Part qp = this.parts.createPart(PartCreator.getCreatePartRequest(metadata.getData().getId(), metadata.getData().getAttributes().getName(), partMetadata));
        UUID partId = JobPoller.pollUntilJobDone("part", () -> this.tiApi.getQueuedTranslation(qp.getData().getId()));
        return this.parts.getPart(partId, null);
    }

    public CompletableFuture<Part> createPartFromFileAsync(UUID id, CreateFileRequest req) {
        return this.createPartFromFileAsync(id, req, Collections.emptyMap());
    }

    public CompletableFuture<Part> createPartFromFileAsync(UUID id, CreateFileRequest req, Map<String, AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType> metadata) {
        CompletableFuture p = CallbackUtil.execute(cb -> this.parts.createPartAsync(PartCreator.getCreatePartRequest(id, req.getData().getAttributes().getName(), metadata), (ApiCallback<Part>)cb));
        CompletionStage partId = p.thenCompose(qj -> JobPoller.pollUntilJobDoneAsync("part", () -> CallbackUtil.execute(cb -> this.tiApi.getQueuedTranslationAsync(qj.getData().getId(), (ApiCallback<QueuedJob>)cb))));
        return ((CompletableFuture)partId).thenCompose(pId -> CallbackUtil.execute(cb -> this.parts.getPartAsync((UUID)pId, null, (ApiCallback<Part>)cb)));
    }

    public CompletableFuture<Part> createAssemblyFromRevisions(List<UUID> revisions, String name) {
        CompletableFuture p = CallbackUtil.execute(cb -> this.parts.createPartAsync(PartCreator.createPartAssemblyRequest(revisions, name), (ApiCallback<Part>)cb));
        return p.thenCompose(pId -> CallbackUtil.execute(cb -> this.parts.getPartAsync(pId.getData().getId(), null, (ApiCallback<Part>)cb)));
    }

    private static CreatePartRequest getCreatePartRequest(UUID fileId, String partName) {
        return PartCreator.getCreatePartRequest(fileId, partName, Collections.emptyMap());
    }

    private static CreatePartRequest getCreatePartRequest(UUID fileId, String partName, Map<String, AnyOfMetadataLongTypeMetadataFloatTypeMetadataDateTypeMetadataStringTypeMetadataNullType> metadata) {
        FileRelationship fileRelationship = new FileRelationship().data(new FileRelationshipData().id(fileId).type(FileRelationshipData.TypeEnum.FILE));
        return new CreatePartRequest().data(new CreatePartRequestData().type("part").attributes(new CreatePartRequestDataAttributes().suppliedId("my-part-" + String.valueOf(UUID.randomUUID())).suppliedRevisionId("my-part-rev-A").name(partName).metadata(metadata)).relationships(new CreatePartRequestDataRelationships().source(new AnyOfFileRelationshipPartAssemblyRelationship(fileRelationship))));
    }

    private static CreatePartRequest createPartAssemblyRequest(List<UUID> revisionIds, String assemblyName) {
        PartAssemblyRelationship partAssemblyRelationship = new PartAssemblyRelationship().data(new PartAssemblyRelationshipData().metadata(Collections.emptyMap()).children(PartCreator.createPartRevisionInstances(revisionIds)));
        UUID uuid = UUID.randomUUID();
        return new CreatePartRequest().data(new CreatePartRequestData().type("assembly").attributes(new CreatePartRequestDataAttributes().suppliedId("my-assembly-" + String.valueOf(uuid)).suppliedRevisionId("my-part-rev-" + String.valueOf(uuid)).name(assemblyName)).relationships(new CreatePartRequestDataRelationships().source(new AnyOfFileRelationshipPartAssemblyRelationship(partAssemblyRelationship))));
    }

    private static List<PartRevisionInstance> createPartRevisionInstances(List<UUID> ids) {
        int num = ids.size();
        return IntStream.range(0, num).mapToObj(ordinal -> new PartRevisionInstance().ordinal(ordinal).revisionId((UUID)ids.get(ordinal)).transform(new Matrix4().r0(PartCreator.createVector4(BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE)).r1(PartCreator.createVector4(BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ONE)).r2(PartCreator.createVector4(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ONE)).r3(PartCreator.createVector4(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE)))).collect(Collectors.toList());
    }

    private static Vector4 createVector4(BigDecimal x, BigDecimal y, BigDecimal z, BigDecimal w) {
        return new Vector4().x(x).y(y).z(z).w(w);
    }
}

