/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CreateFileRequestDataAttributes {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SUPPLIED_ID = "suppliedId";
    @SerializedName(value="suppliedId")
    private String suppliedId;
    public static final String SERIALIZED_NAME_ROOT_FILE_NAME = "rootFileName";
    @SerializedName(value="rootFileName")
    private String rootFileName;
    public static final String SERIALIZED_NAME_EXPIRY = "expiry";
    @SerializedName(value="expiry")
    private Integer expiry;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;

    public CreateFileRequestDataAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="model.zip", required=true, value="Name matching that of the file you are uploading, including file extension.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateFileRequestDataAttributes suppliedId(String suppliedId) {
        this.suppliedId = suppliedId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PN12345", value="ID provided for correlation. For example, an existing ID from a PLM system.")
    public String getSuppliedId() {
        return this.suppliedId;
    }

    public void setSuppliedId(String suppliedId) {
        this.suppliedId = suppliedId;
    }

    public CreateFileRequestDataAttributes rootFileName(String rootFileName) {
        this.rootFileName = rootFileName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="root-assembly.prt.1", value="File name of the root part or assembly, including file extension. Required if `name` references an archive file extension, ignored otherwise.")
    public String getRootFileName() {
        return this.rootFileName;
    }

    public void setRootFileName(String rootFileName) {
        this.rootFileName = rootFileName;
    }

    public CreateFileRequestDataAttributes expiry(Integer expiry) {
        this.expiry = expiry;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="600", value="Number of seconds before the file is deleted.")
    public Integer getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Integer expiry) {
        this.expiry = expiry;
    }

    public CreateFileRequestDataAttributes metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CreateFileRequestDataAttributes putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User supplied key-value pairs for a file. You can supply up to 50 entries, with key names limited to 64 characters and values limited to 256 characters. ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFileRequestDataAttributes createFileRequestDataAttributes = (CreateFileRequestDataAttributes)o;
        return Objects.equals(this.name, createFileRequestDataAttributes.name) && Objects.equals(this.suppliedId, createFileRequestDataAttributes.suppliedId) && Objects.equals(this.rootFileName, createFileRequestDataAttributes.rootFileName) && Objects.equals(this.expiry, createFileRequestDataAttributes.expiry) && Objects.equals(this.metadata, createFileRequestDataAttributes.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.suppliedId, this.rootFileName, this.expiry, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFileRequestDataAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    suppliedId: ").append(this.toIndentedString(this.suppliedId)).append("\n");
        sb.append("    rootFileName: ").append(this.toIndentedString(this.rootFileName)).append("\n");
        sb.append("    expiry: ").append(this.toIndentedString(this.expiry)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

