/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vertexvis.model.FileCollectionMetadataDataAttributes;
import com.vertexvis.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileCollectionMetadataData {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private FileCollectionMetadataDataAttributes attributes;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private Map<String, Link> links = null;

    public FileCollectionMetadataData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="file-collection", required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FileCollectionMetadataData id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="f79d4760-0b71-44e4-ad0b-22743fdd4ca3", required=true, value="ID of the resource.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public FileCollectionMetadataData attributes(FileCollectionMetadataDataAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public FileCollectionMetadataDataAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(FileCollectionMetadataDataAttributes attributes) {
        this.attributes = attributes;
    }

    public FileCollectionMetadataData links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public FileCollectionMetadataData putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileCollectionMetadataData fileCollectionMetadataData = (FileCollectionMetadataData)o;
        return Objects.equals((Object)this.type, (Object)fileCollectionMetadataData.type) && Objects.equals(this.id, fileCollectionMetadataData.id) && Objects.equals(this.attributes, fileCollectionMetadataData.attributes) && Objects.equals(this.links, fileCollectionMetadataData.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.attributes, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileCollectionMetadataData {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FILE_COLLECTION("file-collection");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

