/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import com.vertexvis.model.Vector3;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="A type that describes a callout annotation.")
public class SceneAnnotationCalloutDataType {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_POSITION = "position";
    @SerializedName(value="position")
    private Vector3 position;
    public static final String SERIALIZED_NAME_ICON = "icon";
    @SerializedName(value="icon")
    private String icon;
    public static final String SERIALIZED_NAME_PRIMARY_COLOR = "primaryColor";
    @SerializedName(value="primaryColor")
    private String primaryColor;
    public static final String SERIALIZED_NAME_ACCENT_COLOR = "accentColor";
    @SerializedName(value="accentColor")
    private String accentColor;

    public SceneAnnotationCalloutDataType type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="callout", required=true, value="The type of annotation.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SceneAnnotationCalloutDataType position(Vector3 position) {
        this.position = position;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Vector3 getPosition() {
        return this.position;
    }

    public void setPosition(Vector3 position) {
        this.position = position;
    }

    public SceneAnnotationCalloutDataType icon(String icon) {
        this.icon = icon;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="comment-show", value="An optional icon to display for this annotation. See [documentation](https://github.com/Vertexvis/vertex-web-sdk/tree/master/packages/viewer/src/components/viewer-icon#properties) for possible values. ")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public SceneAnnotationCalloutDataType primaryColor(String primaryColor) {
        this.primaryColor = primaryColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="#FFFFFF", value="A hex color value.")
    public String getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(String primaryColor) {
        this.primaryColor = primaryColor;
    }

    public SceneAnnotationCalloutDataType accentColor(String accentColor) {
        this.accentColor = accentColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="#FFFFFF", value="A hex color value.")
    public String getAccentColor() {
        return this.accentColor;
    }

    public void setAccentColor(String accentColor) {
        this.accentColor = accentColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SceneAnnotationCalloutDataType sceneAnnotationCalloutDataType = (SceneAnnotationCalloutDataType)o;
        return Objects.equals(this.type, sceneAnnotationCalloutDataType.type) && Objects.equals(this.position, sceneAnnotationCalloutDataType.position) && Objects.equals(this.icon, sceneAnnotationCalloutDataType.icon) && Objects.equals(this.primaryColor, sceneAnnotationCalloutDataType.primaryColor) && Objects.equals(this.accentColor, sceneAnnotationCalloutDataType.accentColor);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.position, this.icon, this.primaryColor, this.accentColor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SceneAnnotationCalloutDataType {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString(this.icon)).append("\n");
        sb.append("    primaryColor: ").append(this.toIndentedString(this.primaryColor)).append("\n");
        sb.append("    accentColor: ").append(this.toIndentedString(this.accentColor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

