/*
 * Decompiled with CFR 0.152.
 */
package com.vertexvis.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="A type that describes a custom user provided annotation.")
public class SceneAnnotationCustomDataType {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_JSON_TYPE = "jsonType";
    @SerializedName(value="jsonType")
    private String jsonType;
    public static final String SERIALIZED_NAME_JSON = "json";
    @SerializedName(value="json")
    private String json;

    public SceneAnnotationCustomDataType type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="custom", required=true, value="The type of annotation.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SceneAnnotationCustomDataType jsonType(String jsonType) {
        this.jsonType = jsonType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="my-annotation-type", required=true, value="The type of annotation.")
    public String getJsonType() {
        return this.jsonType;
    }

    public void setJsonType(String jsonType) {
        this.jsonType = jsonType;
    }

    public SceneAnnotationCustomDataType json(String json) {
        this.json = json;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"label\":\"my annotation\",\"anchor\":{\"x\":0,\"y\":0,\"z\":0}}", required=true, value="An encoded JSON string associated with the custom annotation.")
    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SceneAnnotationCustomDataType sceneAnnotationCustomDataType = (SceneAnnotationCustomDataType)o;
        return Objects.equals(this.type, sceneAnnotationCustomDataType.type) && Objects.equals(this.jsonType, sceneAnnotationCustomDataType.jsonType) && Objects.equals(this.json, sceneAnnotationCustomDataType.json);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.jsonType, this.json);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SceneAnnotationCustomDataType {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    jsonType: ").append(this.toIndentedString(this.jsonType)).append("\n");
        sb.append("    json: ").append(this.toIndentedString(this.json)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

