/*
 * Decompiled with CFR 0.152.
 */
package com.viafirma.documents.sdk.java;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.viafirma.documents.sdk.java.ApiException;
import com.viafirma.documents.sdk.java.JsonUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.oauth1.AccessToken;
import org.glassfish.jersey.client.oauth1.ConsumerCredentials;
import org.glassfish.jersey.client.oauth1.OAuth1ClientSupport;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

public class ApiInvoker {
    private Integer timeoutInMillis;
    String basePath = null;
    String consumerKey = null;
    String consumerSecret = null;
    String token = null;
    String tokenSecret = null;
    String username = null;
    String password = null;
    String proxyHost = null;
    int proxyPort = 0;

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public Integer getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public void setTimeoutInMillis(Integer timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        if (proxyHost != null && !"".equals(proxyHost) && !proxyHost.toLowerCase().startsWith("http://")) {
            proxyHost = "http://" + proxyHost;
        }
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static Object deserialize(String json, String containerType, Class cls) throws ApiException {
        if (null != containerType) {
            containerType = containerType.toLowerCase();
        }
        try {
            if ("list".equals(containerType) || "array".equals(containerType)) {
                CollectionType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructCollectionType(List.class, cls);
                List response = (List)JsonUtil.getJsonMapper().readValue(json, (JavaType)typeInfo);
                return response;
            }
            if (String.class.equals((Object)cls)) {
                if (json != null && json.startsWith("\"") && json.endsWith("\"") && json.length() > 1) {
                    return json.substring(1, json.length() - 1);
                }
                return json;
            }
            return JsonUtil.getJsonMapper().readValue(json, cls);
        }
        catch (IOException e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public String invokeAPI(String path, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams, Map<String, String> formParams, String contentType) throws ApiException {
        MultivaluedHashMap formData;
        Client client = this.getClient(this.basePath, this.proxyHost, this.proxyPort);
        StringBuilder b = new StringBuilder();
        for (String key : queryParams.keySet()) {
            String value = queryParams.get(key);
            if (value == null) continue;
            if (b.toString().length() == 0) {
                b.append("?");
            } else {
                b.append("&");
            }
            b.append(this.escapeString(key)).append("=").append(this.escapeString(value));
        }
        String querystring = b.toString();
        WebTarget target = client.target(this.basePath + path + querystring);
        target.request().accept(new String[]{"application/json"});
        for (String key : headerParams.keySet()) {
            target.request().header(key, (Object)headerParams.get(key));
        }
        Response response = null;
        if ("GET".equals(method)) {
            response = target.request().get();
        } else if ("POST".equals(method)) {
            if (body instanceof FormDataMultiPart) {
                response = target.request().post(Entity.json((Object)body));
            } else if (formParams != null && !formParams.isEmpty()) {
                formData = new MultivaluedHashMap();
                for (Map.Entry<String, String> entry : formParams.entrySet()) {
                    formData.add((Object)entry.getKey(), (Object)entry.getValue());
                }
                response = target.request().post(Entity.form((MultivaluedMap)formData));
            } else {
                response = target.request(new String[]{"application/json"}).post(Entity.json((Object)body));
            }
        } else if ("PUT".equals(method)) {
            if (body instanceof FormDataMultiPart) {
                response = target.request().put(Entity.json((Object)body));
            } else if (formParams != null && !formParams.isEmpty()) {
                formData = new MultivaluedHashMap();
                for (Map.Entry<String, String> object : formParams.entrySet()) {
                }
                StringBuilder formParamBuilder = new StringBuilder();
                for (String key : formParams.keySet()) {
                    String value = formParams.get(key);
                    if (value == null || "".equals(value.trim())) continue;
                    if (formParamBuilder.length() > 0) {
                        formParamBuilder.append("&");
                    }
                    try {
                        formParamBuilder.append(URLEncoder.encode(key, "utf8")).append("=").append(URLEncoder.encode(value, "utf8"));
                    }
                    catch (Exception exception) {}
                }
                target = client.target(this.basePath + path + "?" + formParamBuilder.toString());
                response = target.request().put(Entity.form((MultivaluedMap)formData));
            } else {
                response = target.request(new String[]{"application/json"}).put(Entity.json((Object)body));
            }
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        if (!response.hasEntity()) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            return (String)response.readEntity(String.class);
        }
        throw new ApiException(response.getStatus(), (String)response.readEntity(String.class));
    }

    public byte[] invokeAPIArray(String path, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams, Map<String, String> formParams, String contentType) throws ApiException {
        Client client = this.getClient(this.basePath, this.proxyHost, this.proxyPort);
        StringBuilder b = new StringBuilder();
        for (String key : queryParams.keySet()) {
            String value = queryParams.get(key);
            if (value == null) continue;
            if (b.toString().length() == 0) {
                b.append("?");
            } else {
                b.append("&");
            }
            b.append(this.escapeString(key)).append("=").append(this.escapeString(value));
        }
        String querystring = b.toString();
        WebTarget target = client.target(this.basePath + path + querystring);
        target.request().accept(new String[]{"application/json"});
        for (String key : headerParams.keySet()) {
            target.request().header(key, (Object)headerParams.get(key));
        }
        Response response = target.request().get();
        if (!response.hasEntity()) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            return (byte[])response.readEntity(byte[].class);
        }
        throw new ApiException(response.getStatus(), (String)response.readEntity(String.class));
    }

    private Client getClient(String host, String proxyHost, int proxyPort) {
        Client client;
        if (StringUtils.isNotBlank((CharSequence)proxyHost) && proxyPort != 0) {
            ClientConfig config = new ClientConfig();
            config.property("jersey.config.client.proxy.uri", (Object)(proxyHost + ":" + proxyPort));
            config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            client = ClientBuilder.newClient((Configuration)config);
        } else {
            client = ClientBuilder.newClient();
        }
        if (StringUtils.isNotBlank((CharSequence)this.consumerKey) && StringUtils.isNotBlank((CharSequence)this.consumerSecret)) {
            Feature filterFeature;
            ConsumerCredentials consumerCredentials = new ConsumerCredentials(this.consumerKey, this.consumerSecret);
            if (StringUtils.isNotBlank((CharSequence)this.token) && StringUtils.isNotBlank((CharSequence)this.tokenSecret)) {
                AccessToken accessToken = new AccessToken(this.token, this.tokenSecret);
                filterFeature = OAuth1ClientSupport.builder((ConsumerCredentials)consumerCredentials).feature().accessToken(accessToken).build();
            } else {
                filterFeature = OAuth1ClientSupport.builder((ConsumerCredentials)consumerCredentials).feature().build();
            }
            client.register((Object)filterFeature);
        } else if (StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password)) {
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)this.username, (String)this.password);
            client.register((Object)feature);
        }
        if (this.timeoutInMillis != null && this.timeoutInMillis > 0) {
            client.property("jersey.config.client.connectTimeout", (Object)this.timeoutInMillis);
            client.property("jersey.config.client.readTimeout", (Object)this.timeoutInMillis);
        }
        return client;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

