/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.cache.persist;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.persist.CacheSnapshot;
import com.vmware.vipclient.i18n.base.cache.persist.CacheSyncThread;
import com.vmware.vipclient.i18n.base.cache.persist.DiskCacheLoader;
import com.vmware.vipclient.i18n.base.cache.persist.Loader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CacheSyncThreadPool
implements Runnable {
    private int maxThreads = 30;
    private int minThreads = 10;
    private int defaultThreads = 5;
    private List<CacheSyncThread> runningThreads = new ArrayList<CacheSyncThread>();

    public CacheSnapshot getCacheSnapshot() {
        return VIPCfg.getInstance().getCacheManager().getCacheSnapshot();
    }

    @Override
    public void run() {
        CacheSnapshot cs = VIPCfg.getInstance().getCacheManager().getCacheSnapshot();
        Set<String> s = cs.getComponents();
        ArrayList list = new ArrayList();
        int curentThreads = this.defaultThreads;
        if (s.size() > 1000) {
            curentThreads = this.maxThreads;
        } else if (s.size() > 100) {
            curentThreads = this.minThreads;
        }
        Loader loader = VIPCfg.getInstance().getCacheManager().getLoaderInstance(DiskCacheLoader.class);
        for (String key : s) {
            boolean c = false;
            HashSet<String> components = new HashSet<String>();
            for (int j = 0; j < curentThreads; ++j) {
                components.add(key);
            }
            CacheSyncThread t = new CacheSyncThread(components, cs.getLocales(), loader);
            this.runningThreads.add(t);
            t.start();
        }
        while (!this.isComplete()) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        loader.refreshCacheSnapshot(this.getCacheSnapshot());
    }

    public boolean isComplete() {
        boolean f = false;
        for (CacheSyncThread t : this.runningThreads) {
            if (t.isAlive() || t.isInterrupted()) break;
        }
        return f;
    }
}

